/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.preferences;

import org.eclipse.jface.dialogs.IInputValidator;
import org.tizen.common.sign.preferences.SigningProfileContainer;
import org.tizen.common.sign.preferences.UIMessages;
import org.tizen.common.util.StringUtil;

class InputValidator
implements IInputValidator {
    protected final String oldProfileName;
    protected final SigningProfileContainer container;

    InputValidator(SigningProfileContainer container) {
        this(container, null);
    }

    InputValidator(SigningProfileContainer container, String oldProfileName) {
        this.container = container;
        this.oldProfileName = oldProfileName;
    }

    public String isValid(String newText) {
        if (StringUtil.isEmpty((CharSequence)newText)) {
            return "";
        }
        String safeText = StringUtil.trim((String)newText);
        if (this.oldProfileName != null && this.oldProfileName.equals(safeText)) {
            return "This is the same with previous name";
        }
        if (this.container.containsProfile(newText.trim())) {
            return String.valueOf(UIMessages.getString("org.tizen.common.sign.profile")) + " " + safeText + " " + UIMessages.getString("org.tizen.common.sign.aldreadyexists");
        }
        return null;
    }
}

