/*
* Web IDE - Command Line Interface
*
* Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
*
* Contact:
* GyeongSeok Seo <gyeongseok.seo@samsung.com>
* BonYong Lee <bonyong.lee@samsung.com>
* 
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
* Contributors:
* - S-Core Co., Ltd
*
*/
package org.tizen.cli.exec.debug;

import static org.tizen.cli.exec.LaunchOptionConstants.OPT_WIDGETID;
import static org.tizen.cli.exec.LaunchOptionConstants.DESC_FAILED_MODE_SETTING;
import static org.tizen.cli.exec.LaunchOptionConstants.DESC_WIDGETID;
import static org.tizen.cli.exec.LaunchOptionConstants.DESC_FAILED_CANNOT_FIND_WIDGET_ID;
import static org.tizen.cli.exec.LaunchOptionConstants.DESC_FAILED_CANNOT_FIND_CONNECTED_DEVICE;
import static org.tizen.cli.exec.LaunchOptionConstants.DESC_FAILED_CANNOT_FIND_SELECTED_DEVICE;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.tizen.cli.exec.Help;
import org.tizen.cli.exec.WRTLauncher;
import org.tizen.common.core.command.Executor;
import org.tizen.common.core.command.Prompter;
import org.tizen.common.util.StringUtil;
import org.tizen.web.zimlaunch.cli.command.CheckInstallCommand;
import org.tizen.web.zimlaunch.cli.command.DebugCommand;
import org.tizen.web.zimlaunch.cli.command.KillCommand;
import org.tizen.web.zimlaunch.cli.command.ModeCommnad;

/**
 * Command Line Interface for debug run widget in target
 * 
 * @author GyeongSeok Seo{@literal <gyeongseok.seo@samsung.com>} (S-Core)
 * @author BonYong Lee{@literal <bonyong.lee@samsung.com>} (S-Core)
 */
public class
Main
extends WRTLauncher
{
    protected String FAILED_LAUNCH = "Failed to launch: ";

    /**
     * Entry point for cli main
     * 
     * @param args user input parameter
     * 
     * @throws Exception If unhandled exception occur
     */
    public static
    void
    main(
        final String[] args
    )
    throws Exception
    {
        final Main instance = new Main();
        instance.run( args );
    }

    /* (non-Javadoc)
     * @see org.tizen.cli.exec.AbstractLauncher#execute(org.apache.commons.cli.CommandLine)
     */
    @Override
    protected
    void
    execute(
        final CommandLine cmdLine
    )
    throws Exception
    {
        super.execute( cmdLine );

        final Prompter prompter = getPrompter();
        final Executor exec = getExecutor();

        // get widget AppID
        logger.trace( "application id value input check" );
        String widgetId = cmdLine.getOptionValue( OPT_WIDGETID );
        if ( StringUtil.isEmpty( widgetId ) ) {
            prompter.error( FAILED_LAUNCH + DESC_FAILED_CANNOT_FIND_WIDGET_ID );
            exit( 1 );
        }

        // mode command
        ModeCommnad mode_command = new ModeCommnad();
        mode_command.setDevice( getDevice() );
        mode_command.setTime( getTime() );
        mode_command.setPrintOption( false );

        // widget mode
        logger.trace( "mode command");
        exec.execute( mode_command );
        if ( mode_command.getResult().contains( "Failed" ) ) {
            prompter.error( FAILED_LAUNCH + DESC_FAILED_MODE_SETTING );
            exit( 1 );
        }

        // already run check and kill
        logger.trace( "same widget's pre-install check and kill process" );
        CheckInstallCommand check_install_cmd = new CheckInstallCommand( widgetId );
        check_install_cmd.setDevice( getDevice() );
        check_install_cmd.setTime( getTime() );
        check_install_cmd.setPrintOption( false );
        exec.execute( check_install_cmd );
        if ( check_install_cmd.isInstalled() ) {
            KillCommand kill_cmd = new KillCommand( widgetId );
            kill_cmd.setPrintOption( false );
            kill_cmd.setDevice( getDevice() );
            kill_cmd.setTime( getTime() );
            exec.execute( kill_cmd );
        }

        // widget debug run
        DebugCommand run_command = new DebugCommand( widgetId );
        run_command.setDevice( getDevice() );
        run_command.setTime( getTime() );
        run_command.setPrintOption( false );
        exec.execute( run_command );

        prompter.notify( run_command.getResult() );
        if ( run_command.getResult().contains( "failed" ) ) {
            exit( 1 );
        } else {
            exit( 0 );
        }
    }

    /* (non-Javadoc)
     * @see org.tizen.cli.exec.AbstractLauncher#getOptions()
     */
    @Override
    @SuppressWarnings("static-access")
    protected
    Options
    getOptions()
    {
        final Options opts = super.getOptions();
        opts.addOption( OptionBuilder.hasArg().isRequired().withLongOpt( OPT_WIDGETID ).withDescription( DESC_WIDGETID ).create( OPT_WIDGETID.substring( 0, 1 ) ) );

        return opts;
    }

    /* (non-Javadoc)
     * @see org.tizen.cli.exec.WRTLauncher#getDeviceNotConnectedMessage()
     */
    @Override
    protected String getDeviceNotConnectedMessage() {
        return FAILED_LAUNCH + DESC_FAILED_CANNOT_FIND_CONNECTED_DEVICE;
    }

    /* (non-Javadoc)
     * @see org.tizen.cli.exec.WRTLauncher#getDeviceNotSelectedMessage()
     */
    @Override
    protected String getDeviceNotSelectedMessage() {
        return FAILED_LAUNCH + DESC_FAILED_CANNOT_FIND_SELECTED_DEVICE;
    }

    /* (non-Javadoc)
     * @see org.tizen.cli.exec.AbstractLauncher#createHelp()
     */
    @Override
    protected Help createHelp() {
        Help help = super.createHelp();

        help.setSyntax( help.getSyntax() + getSyntax() );
        return help;
    }

    /* (non-Javadoc)
     * @see org.tizen.cli.exec.AbstractLauncher#getSyntax()
     */
    @Override
    protected
    String
    getSyntax()
    {
        return " [options] --id widget-id";
    }
}
