/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.ui.dialogs;

import java.text.MessageFormat;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class EditableDialogCellEditor
extends CellEditor {
    public static final String CELL_EDITOR_IMG_DOTS_BUTTON = "cell_editor_dots_button_image";
    private Composite editor;
    private Control contents;
    private Button button;
    private Text defaultText;
    private FocusListener buttonFocusListener;
    private Object value = null;
    private static final int defaultStyle = 0;

    static {
        ImageRegistry reg = JFaceResources.getImageRegistry();
        reg.put(CELL_EDITOR_IMG_DOTS_BUTTON, ImageDescriptor.createFromFile(EditableDialogCellEditor.class, (String)"images/dots_button.gif"));
    }

    protected EditableDialogCellEditor(Composite parent) {
        this.setStyle(0);
        this.create(parent);
    }

    protected Button createButton(Composite parent) {
        Button result = new Button(parent, 1024);
        result.setText("...");
        return result;
    }

    protected Control createContents(Composite cell) {
        this.defaultText = new Text(cell, 16384);
        this.defaultText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    EditableDialogCellEditor.this.doSetValue(EditableDialogCellEditor.this.doGetValue());
                } else if (e.detail == 4) {
                    String str = EditableDialogCellEditor.this.defaultText.getText();
                    EditableDialogCellEditor.this.doSetValue(str);
                }
            }
        });
        this.defaultText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                String str = EditableDialogCellEditor.this.defaultText.getText();
                EditableDialogCellEditor.this.doSetValue(str);
            }
        });
        this.defaultText.setFont(cell.getFont());
        this.defaultText.setBackground(cell.getBackground());
        return this.defaultText;
    }

    protected Control createControl(Composite parent) {
        Font font = parent.getFont();
        Color bg = parent.getBackground();
        this.editor = new Composite(parent, this.getStyle());
        this.editor.setFont(font);
        this.editor.setBackground(bg);
        this.editor.setLayout((Layout)new DialogCellLayout());
        this.contents = this.createContents(this.editor);
        this.updateContents(this.value);
        this.button = this.createButton(this.editor);
        this.button.setFont(font);
        this.button.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u001b') {
                    EditableDialogCellEditor.this.fireCancelEditor();
                }
            }
        });
        this.button.addFocusListener(this.getButtonFocusListener());
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditableDialogCellEditor.this.button.removeFocusListener(EditableDialogCellEditor.this.getButtonFocusListener());
                Object newValue = EditableDialogCellEditor.this.openDialogBox((Control)EditableDialogCellEditor.this.editor);
                EditableDialogCellEditor.this.button.addFocusListener(EditableDialogCellEditor.this.getButtonFocusListener());
                if (newValue != null) {
                    boolean newValidState = EditableDialogCellEditor.this.isCorrect(newValue);
                    if (newValidState) {
                        EditableDialogCellEditor.this.markDirty();
                        EditableDialogCellEditor.this.doSetValue(newValue);
                    } else {
                        EditableDialogCellEditor.this.setErrorMessage(MessageFormat.format(EditableDialogCellEditor.this.getErrorMessage(), newValue.toString()));
                    }
                    EditableDialogCellEditor.this.fireApplyEditorValue();
                }
            }
        });
        this.setValueValid(true);
        return this.editor;
    }

    public void deactivate() {
        if (this.button != null && !this.button.isDisposed()) {
            this.button.removeFocusListener(this.getButtonFocusListener());
        }
        super.deactivate();
    }

    protected Object doGetValue() {
        return this.value;
    }

    protected void doSetFocus() {
        this.button.setFocus();
        this.button.addFocusListener(this.getButtonFocusListener());
    }

    private FocusListener getButtonFocusListener() {
        if (this.buttonFocusListener == null) {
            this.buttonFocusListener = new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                }
            };
        }
        return this.buttonFocusListener;
    }

    protected void doSetValue(Object value) {
        if (value == null) {
            value = "";
        }
        this.value = value;
        this.updateContents(value);
    }

    protected Text getDefaultText() {
        return this.defaultText;
    }

    protected abstract Object openDialogBox(Control var1);

    protected void updateContents(Object value) {
        if (this.defaultText == null) {
            return;
        }
        String text = "";
        if (value != null) {
            text = value.toString();
        }
        this.defaultText.setText(text);
    }

    private class DialogCellLayout
    extends Layout {
        private DialogCellLayout() {
        }

        public void layout(Composite editor, boolean force) {
            Rectangle bounds = editor.getClientArea();
            Point size = EditableDialogCellEditor.this.button.computeSize(-1, -1, force);
            if (EditableDialogCellEditor.this.contents != null) {
                EditableDialogCellEditor.this.contents.setBounds(0, 0, bounds.width - size.x, bounds.height);
            }
            EditableDialogCellEditor.this.button.setBounds(bounds.width - size.x, 0, size.x, bounds.height);
        }

        public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point contentsSize = EditableDialogCellEditor.this.contents.computeSize(-1, -1, force);
            Point buttonSize = EditableDialogCellEditor.this.button.computeSize(-1, -1, force);
            Point result = new Point(buttonSize.x, Math.max(contentsSize.y, buttonSize.y));
            return result;
        }
    }
}

