/*
 * Decompiled with CFR 0.152.
 */
package zipeditor.operations;

import java.io.File;
import java.io.FileOutputStream;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import zipeditor.Messages;
import zipeditor.Utils;
import zipeditor.ZipEditorPlugin;
import zipeditor.model.Node;
import zipeditor.model.ZipModel;

public class ExtractOperation {
    public static final Object ExtractFamily = new Object();
    private Job fRefreshJob;
    private int fUserStatus = 1;
    private static final int ASK = 1;
    private static final int OVERRIDE = 2;
    private static final Set extracting = new HashSet();

    public File execute(Node[] nodes, File toDir, boolean inBackground, boolean overwrite) {
        return inBackground ? this.extractInBackground(nodes, toDir) : this.extract(nodes, toDir, overwrite, false, (IProgressMonitor)new NullProgressMonitor());
    }

    public void setRefreshJob(Job refreshJob) {
        this.fRefreshJob = refreshJob;
    }

    private File extractInBackground(Node[] nodes, File toDir) {
        if (nodes == null || nodes.length == 0) {
            return toDir;
        }
        File targetDir = this.determineFolderTarget(toDir != null ? toDir : nodes[0].getModel().getTempDir());
        ExtractJob job = new ExtractJob(nodes, targetDir);
        job.setRule(new ExtractRule());
        job.schedule();
        return targetDir;
    }

    public File extract(Node node, File toDir, boolean overwrite, IProgressMonitor monitor) {
        return this.internalExtract(node, toDir, overwrite, true, monitor);
    }

    private File internalExtract(Node node, File toDir, boolean overwrite, boolean fullNodePath, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return null;
        }
        toDir = this.determineFolderTarget(toDir);
        File file = null;
        if (node.isFolder()) {
            File file2 = file = fullNodePath ? toDir : new File(toDir, node.getName());
            if (!file.exists()) {
                file.mkdirs();
            }
            Node[] children = node.getChildren();
            int i = 0;
            while (i < children.length) {
                this.internalExtract(children[i], file, overwrite, fullNodePath, monitor);
                ++i;
            }
        } else {
            block23: {
                boolean writeFile;
                file = new File(toDir, fullNodePath ? node.getFullPath() : node.getName());
                while (extracting.contains(file)) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
                boolean bl = writeFile = !file.exists();
                if (!(writeFile || overwrite || (this.fUserStatus & 1) <= 0 || this.isTempFolder(toDir, node.getModel()))) {
                    switch (this.showWarning(file)) {
                        case 0: {
                            writeFile = true;
                            break;
                        }
                        case 1: {
                            writeFile = true;
                            this.fUserStatus &= 0xFFFFFFFE;
                            this.fUserStatus |= 2;
                            break;
                        }
                        case 3: {
                            this.fUserStatus &= 0xFFFFFFFC;
                            break;
                        }
                        case 4: {
                            monitor.setCanceled(true);
                            return file;
                        }
                    }
                }
                if (writeFile || (this.fUserStatus & 2) > 0) {
                    File parent = file.getParentFile();
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    monitor.subTask(file.getName());
                    try {
                        try {
                            extracting.add(file);
                            long time = System.currentTimeMillis();
                            Utils.readAndWrite(node.getContent(), new FileOutputStream(file), true);
                            if (ZipEditorPlugin.DEBUG) {
                                System.out.println("Extracted " + (Object)((Object)node) + " in " + (System.currentTimeMillis() - time) + "ms");
                            }
                        }
                        catch (Exception e) {
                            node.getModel().logError(e);
                            extracting.remove(file);
                            break block23;
                        }
                    }
                    catch (Throwable throwable) {
                        extracting.remove(file);
                        throw throwable;
                    }
                    extracting.remove(file);
                }
            }
            monitor.worked(1);
        }
        return file;
    }

    private int showWarning(final File file) {
        if (Utils.isUIThread()) {
            return this.doShowWarning(file);
        }
        final int[] result = new int[]{-1};
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                result[0] = ExtractOperation.this.doShowWarning(file);
            }
        });
        return result[0];
    }

    private int doShowWarning(File file) {
        MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.getString("ExtractOperation.2"), null, Messages.getFormattedString("ExtractOperation.3", file.getAbsolutePath()), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        return dialog.open();
    }

    private boolean isTempFolder(File toDir, ZipModel model) {
        File tmp = model.getTempDir();
        return toDir.getAbsolutePath().startsWith(tmp.getAbsolutePath());
    }

    public File extract(Node[] nodes, File toDir, boolean overwrite, boolean fullNodePath, IProgressMonitor monitor) {
        if (nodes == null || nodes.length == 0) {
            return toDir;
        }
        File targetDir = this.determineFolderTarget(toDir != null ? toDir : nodes[0].getModel().getTempDir());
        int i = 0;
        while (i < nodes.length) {
            this.internalExtract(nodes[i], targetDir, overwrite, fullNodePath, monitor);
            ++i;
        }
        return toDir;
    }

    private File determineFolderTarget(File file) {
        while (file != null && !file.isDirectory()) {
            file = file.getParentFile();
        }
        return file;
    }

    private class ExtractJob
    extends Job {
        private Node[] fNodes;
        private File fTargetDir;
        private boolean fOverwrite;

        public ExtractJob(Node[] nodes, File targetDir) {
            super(Messages.getString("ExtractOperation.0"));
            this.fNodes = nodes;
            this.fTargetDir = targetDir;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(Messages.getString("ExtractOperation.1"), Utils.computeTotalNumber(this.fNodes, monitor));
            ExtractOperation.this.extract(this.fNodes, this.fTargetDir, this.fOverwrite, false, monitor);
            if (ExtractOperation.this.fRefreshJob != null) {
                ExtractOperation.this.fRefreshJob.schedule();
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return family == ExtractFamily;
        }
    }

    public static class ExtractRule
    implements ISchedulingRule {
        public boolean contains(ISchedulingRule rule) {
            return rule instanceof ExtractRule;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule instanceof ExtractRule;
        }
    }
}

