/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.preferenceWindow.widgets;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.mihalis.opal.preferenceWindow.PreferenceWindow;
import org.mihalis.opal.preferenceWindow.widgets.PWWidget;

public class PWScale
extends PWWidget {
    private final int max;
    private final int min;
    private final int increment;

    public PWScale(String label, String propertyKey, int min, int max, int increment) {
        super(label, propertyKey, label == null ? 1 : 2, false);
        this.min = min;
        this.max = max;
        this.increment = increment;
    }

    @Override
    public Control build(Composite parent) {
        this.buildLabel(parent, 2);
        final Scale scale = new Scale(parent, 256);
        this.addControl((Control)scale);
        scale.setIncrement(this.increment);
        scale.setMinimum(this.min);
        scale.setMaximum(this.max);
        Integer originalValue = (Integer)PreferenceWindow.getInstance().getValueFor(this.getPropertyKey());
        scale.setSelection(originalValue.intValue());
        scale.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                PreferenceWindow.getInstance().setValue(PWScale.this.getPropertyKey(), new Integer(scale.getSelection()));
            }
        });
        return scale;
    }

    @Override
    public void check() {
        Object value = PreferenceWindow.getInstance().getValueFor(this.getPropertyKey());
        if (value == null) {
            PreferenceWindow.getInstance().setValue(this.getPropertyKey(), new Integer(this.min));
        } else {
            if (!(value instanceof Integer)) {
                throw new UnsupportedOperationException("The property '" + this.getPropertyKey() + "' has to be an Integer because it is associated to a iscale");
            }
            int valueAsInt = (Integer)value;
            if (valueAsInt < this.min || valueAsInt > this.max) {
                throw new UnsupportedOperationException("The property '" + this.getPropertyKey() + "' is out of range (value is " + valueAsInt + ", range is " + this.min + "-" + this.max + ")");
            }
        }
    }
}

