/*
 * Decompiled with CFR 0.152.
 */
package zipeditor.actions;

import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.PlatformUI;
import zipeditor.ZipEditorPlugin;
import zipeditor.actions.ActionMessages;
import zipeditor.actions.ViewerAction;
import zipeditor.model.Node;

public class CopyAction
extends ViewerAction {
    private boolean fFullyQualified;
    private String fLineSeparator = System.getProperty("line.separator");
    private Clipboard fClipboard;

    public CopyAction(StructuredViewer viewer, boolean fullyQualified, Clipboard clipboard) {
        super(ActionMessages.getString(fullyQualified ? "CopyAction.2" : "CopyAction.0"), viewer);
        this.setToolTipText(ActionMessages.getString(fullyQualified ? "CopyAction.3" : "CopyAction.1"));
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        this.fFullyQualified = fullyQualified;
        this.fClipboard = clipboard;
    }

    public void run() {
        Node[] nodes = this.getSelectedNodes();
        StringBuilder text = new StringBuilder();
        int i = 0;
        while (i < nodes.length) {
            if (i > 0) {
                text.append(this.fLineSeparator);
            }
            text.append(this.fFullyQualified ? String.valueOf(nodes[i].getPath()) + nodes[i].getName() : nodes[i].getName());
            ++i;
        }
        if (text.length() > 0) {
            try {
                this.fClipboard.setContents(new Object[]{text.toString()}, new Transfer[]{TextTransfer.getInstance()});
            }
            catch (SWTError e) {
                ZipEditorPlugin.showErrorDialog(this.getViewer().getControl().getShell(), ActionMessages.getString("CopyAction.2"), e);
            }
        }
    }
}

