/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.opalDialog;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Display;
import org.mihalis.opal.opalDialog.Dialog;
import org.mihalis.opal.utils.SWTGraphicUtil;

abstract class DialogArea {
    protected final Dialog parent;
    private boolean initialised;

    public DialogArea(Dialog parent) {
        this.parent = parent;
    }

    abstract void render();

    boolean isInitialised() {
        return this.initialised;
    }

    void setInitialised(boolean initialised) {
        this.initialised = initialised;
    }

    protected Font getNormalFont() {
        return this.getFont("Segoe UI", 9, 0);
    }

    protected Font getBiggerFont() {
        return this.getFont("Segoe UI", 11, 0);
    }

    private Font getFont(String name, int size, int style) {
        final Font font = new Font((Device)Display.getCurrent(), name, size, style);
        this.parent.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SWTGraphicUtil.dispose((Resource)font);
            }
        });
        return font;
    }

    protected Color getTitleColor() {
        final Color color = new Color((Device)Display.getCurrent(), 35, 107, 178);
        this.parent.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SWTGraphicUtil.dispose((Resource)color);
            }
        });
        return color;
    }

    protected Color getGreyColor() {
        final Color color = new Color((Device)Display.getCurrent(), 240, 240, 240);
        this.parent.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SWTGraphicUtil.dispose((Resource)color);
            }
        });
        return color;
    }

    protected Image getFewerDetailsImage() {
        return this.loadImage("images/fewerDetails.png");
    }

    protected Image getMoreDetailsImage() {
        return this.loadImage("images/moreDetails.png");
    }

    private Image loadImage(String fileName) {
        final Image image = SWTGraphicUtil.createImage(fileName);
        this.parent.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SWTGraphicUtil.dispose((Resource)image);
            }
        });
        return image;
    }
}

