/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.model.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import org.tizen.common.rest.model.schema.AbstractWadlModel;
import org.tizen.common.rest.model.schema.Doc;
import org.tizen.common.rest.model.schema.IReferenceEnabled;
import org.tizen.common.rest.model.schema.IRestUiModel;
import org.tizen.common.rest.model.schema.IWadlModel;
import org.tizen.common.rest.model.schema.Param;
import org.tizen.common.rest.model.schema.Request;
import org.tizen.common.rest.model.schema.Resource;
import org.tizen.common.rest.model.schema.Response;
import org.tizen.common.rest.util.ModelUtil;
import org.tizen.common.util.StringUtil;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"doc", "request", "response", "any"})
@XmlRootElement(name="method")
public class Method
extends AbstractWadlModel
implements IReferenceEnabled,
IRestUiModel,
Cloneable {
    protected List<Doc> doc;
    protected Request request;
    protected List<Response> response;
    @XmlAnyElement(lax=true)
    protected List<Object> any;
    @XmlAttribute(name="id")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    @XmlSchemaType(name="ID")
    protected String id;
    @XmlAttribute(name="name")
    protected String name;
    @XmlAttribute(name="href")
    @XmlSchemaType(name="anyURI")
    protected String href;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();

    public Method() {
    }

    public Method(String id, String description, String name) {
        this.setId(id);
        this.setDescription(description);
        this.setName(name);
    }

    @Override
    public List<IWadlModel> getChildren() {
        ArrayList<IWadlModel> list = new ArrayList<IWadlModel>();
        list.addAll(this.getDoc());
        list.add(this.getRequest());
        list.addAll(this.getResponse());
        return list;
    }

    public List<Doc> getDoc() {
        if (this.doc == null) {
            this.doc = new ArrayList<Doc>();
        }
        return this.doc;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request value) {
        this.request = value;
    }

    public List<Response> getResponse() {
        if (this.response == null) {
            this.response = new ArrayList<Response>();
        }
        return this.response;
    }

    public List<Object> getAny() {
        if (this.any == null) {
            this.any = new ArrayList<Object>();
        }
        return this.any;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        if (!StringUtil.isEmpty((CharSequence)value)) {
            this.id = value;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    @Override
    public String getHref() {
        return this.href;
    }

    public void setHref(String value) {
        this.href = value;
    }

    public void setDescription(String description) {
        if (!StringUtil.isEmpty((CharSequence)description)) {
            List<Doc> dList = this.getDoc();
            if (dList.size() == 0) {
                this.getDoc().add(new Doc(description));
            } else {
                for (Doc doc : dList) {
                    if (StringUtil.isEmpty((CharSequence)doc.getTitle())) continue;
                    doc.setTitle(description);
                    break;
                }
            }
        }
    }

    public String getDescription() {
        List<Doc> dList = this.getDoc();
        String title = null;
        for (Doc doc : dList) {
            title = doc.getTitle();
            if (StringUtil.isEmpty((CharSequence)title)) continue;
            return title;
        }
        return null;
    }

    public Map<QName, String> getOtherAttributes() {
        return this.otherAttributes;
    }

    @Override
    public void addChild(IRestUiModel model) {
        if (model instanceof Request) {
            this.setRequest((Request)model);
            this.request.setParent(this);
        } else if (model instanceof Param) {
            if (this.request == null) {
                this.request = new Request();
                this.setRequest(this.request);
                this.request.setParent(this);
            }
            this.request.addChild(model);
        }
    }

    @Override
    public void removeChild(IRestUiModel model) {
        if (model instanceof Request) {
            Request request = (Request)model;
            this.setRequest(null);
            request.setParent(null);
        }
    }

    @Override
    public boolean isVaildChild(IRestUiModel model) {
        return false;
    }

    @Override
    public IRestUiModel update(IRestUiModel updateModel) {
        if (updateModel instanceof Method) {
            Method method = ModelUtil.findReferences(this);
            Method m = (Method)updateModel;
            if (!this.equals(method)) {
                method = new Method();
                ((Resource)this.getParent()).addChild(method);
                this.delete();
            }
            method.setId(m.getId());
            method.setDescription(m.getDescription());
            method.setName(m.getName());
            return method;
        }
        return null;
    }

    @Override
    public void delete() {
        if (this.getParent() != null) {
            ((Resource)this.getParent()).removeChild(this);
        }
    }

    @Override
    public String getElementId() {
        String result = this.getId();
        if (result == null || result.length() == 0) {
            String id;
            Method method = ModelUtil.findReferences(this);
            String name = method.getName();
            if (name != null && name.length() > 0) {
                result = name;
            }
            if ((id = method.getId()) != null && id.length() > 0) {
                result = String.valueOf(result) + "_" + id;
            }
            if (method != this && this.getParent() instanceof IRestUiModel) {
                IRestUiModel parent = (IRestUiModel)this.getParent();
                String parentId = parent.getElementId();
                result = String.valueOf(parentId) + "/" + result;
            }
        }
        return result;
    }

    @Override
    public String getDisplayName() {
        return "API";
    }

    @Override
    public void insertBefore(IRestUiModel model, IRestUiModel target) {
    }

    @Override
    public void insertAfter(IRestUiModel model, IRestUiModel target) {
    }
}

