/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.autoemul;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.util.FileUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DeviceVMSXmlManager {
    public static final Logger logger = LoggerFactory.getLogger(DeviceVMSXmlManager.class);
    private static final String SDK_DATA_PATH = InstallPathConfig.getUserDataPath();
    private static final String EMULATOR_VMS_PATH = String.valueOf(SDK_DATA_PATH) + File.separator + "emulator" + File.separator + "vms" + File.separator;
    static Map<String, List<String>> deviceMaps = new HashMap<String, List<String>>();

    private static List<String> getVmsDirectories() {
        File[] arrFiles;
        ArrayList<String> list = new ArrayList<String>();
        File p_file = new File(EMULATOR_VMS_PATH);
        if (FileUtil.checkParentDirectory((File)p_file) && (arrFiles = p_file.listFiles()) != null) {
            int i = 0;
            while (i < arrFiles.length) {
                if (arrFiles[i].isDirectory()) {
                    list.add(arrFiles[i].getName());
                }
                ++i;
            }
        }
        return list;
    }

    public static Map<String, List<String>> getVMSDetailInformation() {
        List<String> dirlist = DeviceVMSXmlManager.getVmsDirectories();
        try {
            if (dirlist.size() > 0) {
                DeviceVMSXmlManager.parsingEmulDetailMapFromXml(dirlist);
            } else {
                deviceMaps.clear();
            }
        }
        catch (ParserConfigurationException e) {
            logger.error("failed to parse VMSDetailInformation", (Throwable)e);
        }
        catch (SAXException e) {
            logger.error("failed to parse VMSDetailInformation", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("failed to parse VMSDetailInformation", (Throwable)e);
        }
        return deviceMaps;
    }

    private static void parsingEmulDetailMapFromXml(List<String> dirlist) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        DeviceVMSXmlManager.deviceMapsClear();
        for (String emulName : dirlist) {
            ArrayList<String> list = new ArrayList<String>();
            Path filePath = new Path(String.valueOf(EMULATOR_VMS_PATH) + emulName + File.separator + "vm_config.xml");
            if (!FileUtil.isExist((String)filePath.toString())) continue;
            Document doc = builder.parse(filePath.toString());
            deviceMaps.put(DeviceVMSXmlManager.getNodeContent(doc, "name"), list);
            list.add(DeviceVMSXmlManager.getNodeContent(doc, "width"));
            list.add(DeviceVMSXmlManager.getNodeContent(doc, "height"));
        }
    }

    private static String getNodeContent(Document doc, String NodeName) {
        Node Node2 = doc.getElementsByTagName(NodeName).item(0);
        return Node2.getTextContent();
    }

    private static void deviceMapsClear() {
        if (deviceMaps.isEmpty()) {
            Set<String> s = deviceMaps.keySet();
            Iterator<String> i = s.iterator();
            while (i.hasNext()) {
                List<String> list = deviceMaps.get(i.next());
                list.clear();
            }
        }
        deviceMaps.clear();
    }
}

