/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.classloader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.SecureClassLoader;
import java.util.Collections;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.classloader.ClassSource;
import org.tizen.common.classloader.CompositeClassSource;
import org.tizen.common.util.IOUtil;

public class CustomClassLoader
extends SecureClassLoader {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final ClassLoader parent;
    protected final CompositeClassSource source;

    public CustomClassLoader(ClassSource ... sources) {
        this((ClassLoader)null, sources);
    }

    public CustomClassLoader(ClassLoader parent, ClassSource ... sources) {
        this.parent = parent;
        this.source = new CompositeClassSource(sources);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz;
        String path = String.valueOf(name.replace('.', '/')) + ".class";
        URL url = this.findResource(path);
        if (url == null) {
            return super.findClass(name);
        }
        InputStream in = null;
        try {
            in = url.openStream();
            byte[] bytes = IOUtil.getBytes(in);
            clazz = this.defineClass(name, bytes, 0, bytes.length);
        }
        catch (IOException e) {
            try {
                throw new ClassNotFoundException("Class can't be loaded", e);
            }
            catch (Throwable throwable) {
                IOUtil.tryClose(in);
                throw throwable;
            }
        }
        IOUtil.tryClose(in);
        return clazz;
    }

    @Override
    public URL getResource(String name) {
        this.logger.trace("Resource Name :{}", (Object)name);
        URL url = this.findResource(name);
        if (url == null && this.parent != null) {
            url = this.parent.getResource(name);
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return Collections.enumeration(this.source.getResources(name));
    }

    @Override
    protected URL findResource(String name) {
        this.logger.trace("Resource Name :{}", (Object)name);
        try {
            return this.source.getResource(name);
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

