/*
 * Decompiled with CFR 0.152.
 */
package zipeditor;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import zipeditor.Utils;
import zipeditor.model.Node;
import zipeditor.operations.ExtractOperation;

public class ZipEditorDragAdapter
extends DragSourceAdapter {
    private ISelectionProvider fSelectionProvider;
    private String[] fTempPaths;

    public ZipEditorDragAdapter(ISelectionProvider selectionProvider) {
        this.fSelectionProvider = selectionProvider;
    }

    public void dragSetData(DragSourceEvent event) {
        final Node[] nodes = Utils.getSelectedNodes(this.fSelectionProvider.getSelection());
        if (nodes.length == 0) {
            return;
        }
        boolean createTempFiles = this.fTempPaths == null || this.fTempPaths.length != nodes.length;
        Thread extractor = null;
        if (createTempFiles) {
            this.fTempPaths = new String[nodes.length];
            final File tmpDir = nodes[0].getModel().getTempDir();
            int i = 0;
            while (i < nodes.length) {
                Node node = nodes[i];
                File file = new File(tmpDir, node.getFullPath());
                this.fTempPaths[i] = file.getAbsolutePath();
                if (node.isFolder()) {
                    file.mkdirs();
                }
                ++i;
            }
            extractor = new Thread(new Runnable(){

                @Override
                public void run() {
                    ExtractOperation extractOperation = new ExtractOperation();
                    extractOperation.extract(nodes, tmpDir, true, true, (IProgressMonitor)new NullProgressMonitor());
                }
            }, "Extractor");
            extractor.start();
        }
        if (extractor != null) {
            try {
                extractor.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        event.data = this.fTempPaths;
    }

    public void dragFinished(DragSourceEvent event) {
        this.fTempPaths = null;
    }
}

