/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.logview.view;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.embed.swt.FXCanvas;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.NodeOrientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.tizen.common.connection.logview.controller.ImageButton;
import org.tizen.common.connection.logview.dialog.CustomLogTabDialog;
import org.tizen.common.connection.logview.dialog.CustomLogTabInfo;
import org.tizen.common.connection.logview.model.LogModel;
import org.tizen.common.connection.logview.resources.ImageKind;
import org.tizen.common.connection.logview.service.DeviceDescriptor;
import org.tizen.common.connection.logview.service.DeviceStateType;
import org.tizen.common.connection.logview.service.DeviceType;
import org.tizen.common.connection.logview.view.LogItem;
import org.tizen.common.connection.logview.view.LogTab;
import org.tizen.common.connection.logview.view.LogView;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IDeviceChangeListener;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.TimeoutException;

public class LogPanel
implements IDeviceChangeListener {
    private Composite parent;
    private Map<String, DeviceDescriptor> deviceDescriptors;
    private FXCanvas fxCanvas;
    private AnchorPane rootPane;
    private TabPane tabPane;
    private final String CSS_LOG_VIEW_TAB = "resources/css/log_view_tab.css";
    private final String DEVICE_ONLINE = "online";
    private final String DEVICE_OFFLINE = "offline";
    private final String CLASS_TAB_LABEL = ".tab-label";
    private final String TAB_DISABLED = "disabled";
    private final String TAB_ADD = "tab-add";
    private final Logger logger = Logger.getLogger(LogPanel.class);

    public LogPanel() {
        this.deviceDescriptors = new LinkedHashMap<String, DeviceDescriptor>();
    }

    protected Control createControl(Composite p) {
        this.parent = p;
        this.fxCanvas = new FXCanvas(this.parent, 0);
        this.rootPane = new AnchorPane();
        AnchorPane.setLeftAnchor((Node)this.rootPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.rootPane, (Double)0.0);
        AnchorPane.setTopAnchor((Node)this.rootPane, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)this.rootPane, (Double)0.0);
        this.tabPane = new TabPane();
        this.tabPane.setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
        AnchorPane.setLeftAnchor((Node)this.tabPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.tabPane, (Double)0.0);
        AnchorPane.setTopAnchor((Node)this.tabPane, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)this.tabPane, (Double)0.0);
        this.rootPane.getChildren().add((Object)this.tabPane);
        Scene scene = new Scene((Parent)this.rootPane);
        this.fxCanvas.setScene(scene);
        this.tabPane.getStylesheets().add((Object)LogView.class.getClassLoader().getResource("resources/css/log_view_tab.css").toExternalForm());
        this.addCustomizableTab();
        this.addCopyAcceleratorListener();
        SmartDevelopmentBridge.addDeviceChangeListener((IDeviceChangeListener)this, (boolean)true);
        return this.fxCanvas;
    }

    private ArrayList<LogTab> getSameDeviceLogTabs(DeviceDescriptor device) {
        ArrayList<LogTab> sameDeviceLogTabs = new ArrayList<LogTab>();
        for (Tab tab : this.tabPane.getTabs()) {
            LogModel model;
            if (!(tab instanceof LogTab) || !(model = ((LogTab)tab).getLogModel()).isSameDevice(device)) continue;
            sameDeviceLogTabs.add((LogTab)tab);
        }
        return sameDeviceLogTabs;
    }

    private void addCopyAcceleratorListener() {
        Scene sc = this.rootPane.getScene();
        if (sc != null) {
            sc.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.CONTROL_ANY, KeyCombination.SHORTCUT_ANY}), (Object)new Runnable(){

                @Override
                public void run() {
                    LogItem item;
                    Tab selectedTab = (Tab)LogPanel.this.tabPane.getSelectionModel().getSelectedItem();
                    if (selectedTab != null && selectedTab instanceof LogTab && (item = ((LogTab)selectedTab).getSelectedItem()) != null) {
                        Clipboard clipboard = Clipboard.getSystemClipboard();
                        ClipboardContent content = new ClipboardContent();
                        content.putString(item.messageProperty().get());
                        clipboard.setContent((Map)content);
                    }
                }
            });
        }
    }

    private void enableLogTabs(DeviceDescriptor device) {
        ArrayList<LogTab> sameDeviceLogTabs = this.getSameDeviceLogTabs(device);
        if (sameDeviceLogTabs.size() == 0) {
            try {
                this.createNewLogTab(device, LogTab.generateDefaultTabName(device));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            for (LogTab tab : sameDeviceLogTabs) {
                tab.getLogModel().setDevice(device);
                Node node = (Node)new ArrayList(this.tabPane.lookupAll(".tab-label")).get(this.tabPane.getTabs().indexOf((Object)tab));
                node.getStyleClass().remove((Object)"disabled");
                tab.connect();
            }
        }
    }

    private void disableLogTabs(DeviceDescriptor device) {
        ArrayList<LogTab> sameDeviceLogTabs = this.getSameDeviceLogTabs(device);
        for (LogTab tab : sameDeviceLogTabs) {
            Node node = (Node)new ArrayList(this.tabPane.lookupAll(".tab-label")).get(this.tabPane.getTabs().indexOf((Object)tab));
            node.getStyleClass().add((Object)"disabled");
            tab.disconnect();
        }
    }

    private void addCustomizableTab() {
        Tab addingTab = new Tab();
        addingTab.setClosable(false);
        addingTab.setDisable(true);
        ImageButton addButton = new ImageButton(ImageKind.ICON_LOGVIEW_ADD_TAB_NOR, ImageKind.ICON_LOGVIEW_ADD_TAB_OVER, ImageKind.ICON_LOGVIEW_ADD_TAB_DIM);
        addButton.getPane().setMinSize(58.0, 30.0);
        addButton.setOnMouseClicked(new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (LogPanel.this.deviceDescriptors.size() > 0) {
                    CustomLogTabDialog customDialog = new CustomLogTabDialog(new ArrayList<DeviceDescriptor>(LogPanel.this.deviceDescriptors.values()));
                    try {
                        CustomLogTabInfo tabInfo = (CustomLogTabInfo)customDialog.showAndWait();
                        String tabname = tabInfo.getTabName();
                        DeviceDescriptor device = tabInfo.getTabDevice();
                        if (tabname != null) {
                            LogPanel.this.createNewLogTab(device, tabname);
                        }
                    }
                    catch (Exception e) {
                        LogPanel.this.logger.warn((Object)e.getMessage());
                    }
                }
            }
        });
        addingTab.setGraphic((Node)addButton.getPane());
        addingTab.getStyleClass().add((Object)"tab-add");
        this.tabPane.getTabs().add((Object)addingTab);
    }

    public void createNewLogTab(DeviceDescriptor device, String tabname) throws Exception {
        final LogTab tab = new LogTab(device, tabname);
        tab.setOnClosed((EventHandler)new EventHandler<Event>(){

            public void handle(Event event) {
                LogModel model = tab.getLogModel();
                if (model != null) {
                    model.release();
                }
            }
        });
        tab.connect();
        ObservableList tabs = this.tabPane.getTabs();
        tabs.add(tabs.size() - 1, (Object)tab);
        this.tabPane.getSelectionModel().select((Object)tab);
    }

    public void setVisible(boolean visible) {
        for (Tab tab : this.tabPane.getTabs()) {
            tab.getTabPane().setVisible(visible);
        }
    }

    public void onConnected(IDevice device) {
        String deviceName = device.getDeviceName();
        DeviceDescriptor deviceDesc = null;
        DeviceType deviceType = DeviceType.LOCAL_EMULATOR;
        if (!this.deviceDescriptors.containsKey(deviceName)) {
            deviceDesc = new DeviceDescriptor(device.getSerialNumber(), device);
            try {
                if (device.isRemote()) {
                    deviceType = device.isEmulator() ? DeviceType.REMOTE_EMULATOR : DeviceType.REMOTE_DEVICE;
                } else if (!device.isEmulator()) {
                    deviceType = DeviceType.LOCAL_DEVICE;
                }
                deviceDesc.setDeviceType(deviceType);
                deviceDesc.setDeviceName(deviceName);
                deviceDesc.setProfileName(device.getPlatformInfo().getProfileName());
                deviceDesc.setPlatformName(String.format("%s-%s", device.getPlatformInfo().getProfileName(), device.getPlatformInfo().getPlatformVersion()));
                deviceDesc.setDeviceStateType(DeviceStateType.ONLINE);
                deviceDesc.setIDevice(device);
                deviceDesc.setTooltipName(String.format("%s (%s-%s)", deviceDesc.getSerialId(), deviceDesc.getPlatformName(), device.getArch().name()));
            }
            catch (TimeoutException e) {
                this.logger.error((Object)("Failed to sdb connection by TimeoutException: " + (Object)((Object)e)));
            }
            catch (SdbCommandRejectedException e) {
                this.logger.error((Object)("Failed to sdb connection by SdbCommandRejectedException: " + (Object)((Object)e)));
            }
            catch (IOException e) {
                this.logger.error((Object)("Failed to sdb connection by IOException: " + e));
            }
            this.deviceDescriptors.put(device.getSerialNumber(), deviceDesc);
            this.targetChanged(deviceDesc, DeviceStateType.ONLINE);
        } else {
            deviceDesc = this.deviceDescriptors.get(deviceName);
            this.targetChanged(deviceDesc, DeviceStateType.ONLINE);
        }
        deviceDesc.notifyIDeviceCreated();
    }

    public void onDisconnected(IDevice device) {
        DeviceDescriptor descriptor = this.deviceDescriptors.get(device.getSerialNumber());
        descriptor.setDescriptorName(String.format("%s (%s-%s)", device.getDeviceName(), "offline", device.getArchString()));
        descriptor.setDeviceStateType(DeviceStateType.OFFLINE);
        descriptor.setIDevice(null);
        if (descriptor.getDeviceType() != DeviceType.LOCAL_EMULATOR) {
            this.deviceDescriptors.remove(device.getSerialNumber());
        }
        this.targetChanged(descriptor, DeviceStateType.OFFLINE);
    }

    public void onChanged(IDevice device, int changeMask) {
        if (changeMask == 1) {
            this.onConnected(device);
        }
    }

    private void targetChanged(final DeviceDescriptor device, final DeviceStateType changeMask) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (changeMask.getTypeName().toLowerCase() == "online") {
                    LogPanel.this.logger.info((Object)("Create Device Info: " + device.getDeviceName()));
                    LogPanel.this.enableLogTabs(device);
                } else if (changeMask.getTypeName().toLowerCase() == "offline") {
                    LogPanel.this.disableLogTabs(device);
                }
            }
        });
    }
}

