/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.model.schema;

import java.util.List;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipse.jface.viewers.TreePath;
import org.tizen.common.rest.exception.ResourcesNotFoundException;
import org.tizen.common.rest.model.schema.Application;
import org.tizen.common.rest.model.schema.Doc;
import org.tizen.common.rest.model.schema.IWadlModel;
import org.tizen.common.rest.model.schema.Resources;
import org.tizen.common.util.StringUtil;

public abstract class AbstractWadlModel
implements IWadlModel {
    @XmlTransient
    private IWadlModel parent;

    @Override
    public IWadlModel getParent() {
        return this.parent;
    }

    @XmlTransient
    public void setParent(IWadlModel model) {
        this.parent = model;
    }

    public void afterUnmarshal(Unmarshaller u, Object parent) {
        this.parent = (IWadlModel)parent;
    }

    @Override
    public TreePath getFullPath() {
        if (this.getParent() != null) {
            TreePath parentPath = this.getParent().getFullPath();
            TreePath path = parentPath.createChildPath((Object)this);
            return path;
        }
        return new TreePath(new Object[]{this});
    }

    @Override
    public String getElementName() {
        XmlRootElement rootElement = this.getClass().getAnnotation(XmlRootElement.class);
        if (rootElement != null) {
            return rootElement.name();
        }
        return null;
    }

    @Override
    public Application getRoot() throws ResourcesNotFoundException {
        if (this instanceof Application) {
            return (Application)this;
        }
        return this.getRoot(this);
    }

    private Application getRoot(IWadlModel model) {
        IWadlModel parent = model.getParent();
        if (parent == null) {
            throw new ResourcesNotFoundException(model);
        }
        if (parent instanceof Application) {
            return (Application)parent;
        }
        return this.getRoot(parent);
    }

    @Override
    public Resources findOwnerResources() throws ResourcesNotFoundException {
        if (this instanceof Resources) {
            return (Resources)this;
        }
        return this.findResources(this);
    }

    private Resources findResources(IWadlModel model) {
        IWadlModel parent = model.getParent();
        if (parent == null) {
            throw new ResourcesNotFoundException(model);
        }
        if (parent instanceof Resources) {
            return (Resources)parent;
        }
        return this.findResources(parent);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "@" + Integer.toHexString(this.hashCode());
    }

    protected void setTitle(List<Doc> docList, String value) {
        if (docList != null && !StringUtil.isEmpty((CharSequence)value)) {
            Doc doc2 = null;
            if (docList.size() > 0) {
                for (Doc doc2 : docList) {
                    String title = doc2.getTitle();
                    if (title != null && title.length() > 0) break;
                }
            }
            if (doc2 == null) {
                doc2 = new Doc();
                docList.add(doc2);
            }
            doc2.setTitle(value);
        }
    }

    protected String getTitle(List<Doc> docList) {
        String result = null;
        if (docList != null && docList.size() > 0) {
            for (Doc doc : docList) {
                String title = doc.getTitle();
                if (title == null || title.length() <= 0) continue;
                result = title;
                break;
            }
        }
        return result;
    }
}

