/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.util;

import com.lowagie.text.pdf.BaseFont;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.FontException;

public class FontUtil {
    private static final String LOCALE_CODE_EN_US = "1033";

    public static String getFontFamilyName(String fontPath) throws FontException {
        String ext = FilenameUtil.getExtension(fontPath);
        int fontType = 0;
        try {
            if (!"ttf".equals(ext)) {
                if ("otf".equals(ext)) {
                    String[][] families;
                    BaseFont bf = BaseFont.createFont((String)fontPath, (String)"Cp1252", (boolean)true);
                    String[][] stringArray = families = bf.getFamilyFontName();
                    int n = families.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String[] family = stringArray[n2];
                        if (LOCALE_CODE_EN_US.equals(family[2])) {
                            return family[3];
                        }
                        ++n2;
                    }
                    return families[0][3];
                }
                throw new FontException("Unsupported extension: " + ext);
            }
            fontType = 0;
            Font font = Font.createFont(fontType, new File(fontPath));
            return font.getFamily(Locale.ENGLISH);
        }
        catch (Exception e) {
            throw new FontException(e);
        }
    }

    public static String[] getFontPathList(String fontDir, String ... fontExtensions) throws IOException {
        ArrayList<String> fontPathList = new ArrayList<String>();
        File file = new File(fontDir);
        String[] list = file.list();
        if (list == null) {
            return fontPathList.toArray(new String[0]);
        }
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            String ext = FilenameUtil.getExtension(path);
            String[] stringArray2 = fontExtensions;
            int n3 = fontExtensions.length;
            int n4 = 0;
            while (n4 < n3) {
                String fontExt = stringArray2[n4];
                if (fontExt.equalsIgnoreCase(ext)) {
                    fontPathList.add(path);
                }
                ++n4;
            }
            ++n2;
        }
        return fontPathList.toArray(new String[0]);
    }
}

