/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractAddDialog<T>
extends Dialog {
    private Shell shell;
    protected Button btnOk;
    protected Button btnCancel;
    private T result;
    private List<Text> textControlList = new ArrayList<Text>();

    public AbstractAddDialog(Shell parent, String title) {
        this(parent, 67680, title);
    }

    public AbstractAddDialog(Shell parent, int style, String title) {
        super(parent, style);
        this.setText(title);
    }

    public T open() {
        this.shell = this.createShell();
        this.createControl(this.shell);
        this.initData();
        Shell parent = this.getParent();
        Rectangle rect = parent.getBounds();
        Point size = this.shell.getSize();
        int x = rect.x + rect.width / 2 - size.x / 2;
        int y = rect.y + rect.height / 2 - size.y / 2;
        this.shell.setLocation(new Point(x, y));
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    protected void initData() {
    }

    protected Shell createShell() {
        Shell shell = new Shell(this.getParent(), this.getStyle());
        shell.setText(this.getText());
        shell.setLayout((Layout)new GridLayout(3, false));
        return shell;
    }

    protected void createControl(Shell shell) {
        this.createContents(shell);
        this.createButtonGroup(shell);
        this.getFirstFocusControl().setFocus();
        shell.pack();
    }

    protected void createButtonGroup(Shell shell) {
        Composite composite = new Composite((Composite)shell, 0);
        GridData data = new GridData(0x1000000, 0x1000000, false, false, 3, 1);
        composite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(2, false);
        layout.marginTop = 15;
        composite.setLayout((Layout)layout);
        this.btnOk = new Button(composite, 0);
        this.btnOk.setText("OK");
        this.btnOk.setEnabled(false);
        GridData gd = new GridData();
        gd.widthHint = 80;
        this.btnOk.setLayoutData((Object)gd);
        this.btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractAddDialog.this.okButtonPressed();
            }
        });
        this.btnCancel = new Button(composite, 0);
        this.btnCancel.setText("Cancel");
        gd = new GridData();
        gd.widthHint = 80;
        this.btnCancel.setLayoutData((Object)gd);
        this.btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractAddDialog.this.cancelButtonPressed();
            }
        });
    }

    protected void okButtonPressed() {
        this.updateResult();
        this.close();
    }

    protected void cancelButtonPressed() {
        this.result = null;
        this.close();
    }

    protected void createSeparator(Composite parent, int horizontalSpan) {
        Label separator = new Label(parent, 258);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = horizontalSpan;
        separator.setLayoutData((Object)gridData);
    }

    protected Text createText(Composite parent, int style, int width, int height, boolean isMandatory, int horizontalSpan) {
        final Text text = new Text(parent, style);
        GridData gd = new GridData(768);
        gd.widthHint = width;
        if (height > 0) {
            gd.heightHint = height;
        }
        gd.horizontalSpan = horizontalSpan;
        text.setLayoutData((Object)gd);
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                text.selectAll();
            }
        });
        if (isMandatory) {
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AbstractAddDialog.this.updateOkButtonState();
                }
            });
            this.textControlList.add(text);
        }
        return text;
    }

    protected List<Text> getMandatoryList() {
        return this.textControlList;
    }

    protected void addToMandatoryList(Text text) {
        this.textControlList.add(text);
    }

    protected void removeFromMandatoryList(Text text) {
        this.textControlList.remove(text);
    }

    protected Text createText(Composite parent, int width, boolean isMandatory, int horizontalSpan) {
        return this.createText(parent, 2048, width, 0, isMandatory, horizontalSpan);
    }

    protected Text createText(Composite parent, int width, boolean isMandatory) {
        return this.createText(parent, width, isMandatory, 2);
    }

    protected boolean updateOkButtonState() {
        boolean enabled = this.validate();
        this.btnOk.setEnabled(enabled);
        return enabled;
    }

    protected boolean validate() {
        boolean enabled = true;
        int i = 0;
        while (i < this.textControlList.size()) {
            Text text = this.textControlList.get(i);
            String str = text.getText().trim();
            if (str.length() == 0) {
                enabled = false;
                break;
            }
            ++i;
        }
        return enabled;
    }

    protected void close() {
        this.shell.close();
    }

    protected abstract void createContents(Shell var1);

    protected abstract T makeResult();

    protected abstract Control getFirstFocusControl();

    protected void updateResult() {
        this.result = this.makeResult();
    }

    public Button getBtnOk() {
        return this.btnOk;
    }

    public Button getBtnCancel() {
        return this.btnCancel;
    }
}

