/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.run;

import java.util.ArrayList;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.console.MessageConsoleStream;
import org.tizen.common.rest.RestPlugin;
import org.tizen.common.rest.run.IAuthProcessor;

public abstract class AbstractParamAuthProcessor
implements IAuthProcessor {
    private List<BasicNameValue> paramList;
    private MessageConsoleStream console;

    @Override
    public boolean authentication(Rectangle parentBounds, MessageConsoleStream console, DefaultHttpClient httpClient, String appId) {
        this.console = console;
        this.paramList = this.generateAdditionalParams(appId);
        return true;
    }

    private List<BasicNameValue> generateAdditionalParams(String appId) {
        IPreferenceStore store = RestPlugin.getDefault().getPreferenceStore();
        String payload = store.getString(this.getKeyByAppId("PREF_KEY_AUTH_API_KEY_PAYLOAD", appId));
        String keyName = store.getString(this.getKeyByAppId("PREF_KEY_AUTH_API_KEY_NAME", appId));
        String keyValue = store.getString(this.getKeyByAppId("PREF_KEY_AUTH_API_KEY_VALUE", appId));
        int type = 1;
        if ("Parameter".equals(payload)) {
            type = 2;
        }
        ArrayList<BasicNameValue> list = new ArrayList<BasicNameValue>();
        list.add(new BasicNameValue(type, (NameValuePair)new BasicNameValuePair(keyName, keyValue)));
        return list;
    }

    private String getKeyByAppId(String originalKey, String appId) {
        String result = originalKey;
        if (appId != null && appId.length() > 0) {
            result = String.valueOf(result) + "." + appId;
        }
        return result;
    }

    public List<BasicNameValue> getParamList() {
        return this.paramList;
    }

    public MessageConsoleStream getConsole() {
        return this.console;
    }

    public static class BasicNameValue {
        public static final int TYPE_HEADER = 1;
        public static final int TYPE_PARAM = 2;
        private int type;
        private NameValuePair pair;

        public BasicNameValue(int type, NameValuePair pair) {
            this.type = type;
            this.pair = pair;
        }

        public int getType() {
            return this.type;
        }

        public NameValuePair getPair() {
            return this.pair;
        }
    }
}

