/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.verrari.template;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.tizen.common.util.Assert;
import org.tizen.common.util.IOUtil;
import org.tizen.common.verrari.ITemplate;
import org.tizen.common.verrari.ITemplateProvider;
import org.tizen.common.verrari.template.TemplateTransformer;
import org.tizen.common.verrari.template.TransformableTemplate;

public class TemplateProvider
implements ITemplateProvider,
Closeable {
    protected TemplateTransformer transformer;
    protected Map<String, ITemplate> templates;

    public TemplateProvider() {
        this(new HashMap<String, ITemplate>());
    }

    public TemplateProvider(Map<String, ITemplate> templates) {
        Assert.notNull(templates);
        this.templates = templates;
    }

    @Override
    public ITemplate getTemplate(String key) {
        ITemplate template = this.templates.get(key);
        if (template == null) {
            return null;
        }
        if (this.transformer != null) {
            return new TransformableTemplate(this.transformer, template);
        }
        return template;
    }

    @Override
    public boolean isEmpty() {
        return this.templates.isEmpty();
    }

    @Override
    public Collection<String> keys() {
        return Collections.unmodifiableCollection(this.templates.keySet());
    }

    @Override
    public void close() throws IOException {
        IOUtil.tryClose((Object[])this.templates.values().toArray());
    }

    @Override
    public void setTransformer(TemplateTransformer transformer) {
        this.transformer = transformer;
    }
}

