/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.verrari.template;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import org.tizen.common.FactoryWithArgument;
import org.tizen.common.core.command.ExecutionContext;
import org.tizen.common.file.Filter;
import org.tizen.common.util.ArrayUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.OSChecker;
import org.tizen.common.util.ReflectionUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.common.verrari.IModelProvider;
import org.tizen.common.verrari.ITemplate;
import org.tizen.common.verrari.ITemplateEngine;
import org.tizen.common.verrari.ITemplateProvider;
import org.tizen.common.verrari.Storage;
import org.tizen.common.verrari.TemplateException;
import org.tizen.common.verrari.engine.TemplateEngineFactory;
import org.tizen.common.verrari.exception.InvalidMapperException;
import org.tizen.common.verrari.realm.CommonRealm;
import org.tizen.common.verrari.realm.JarRealm;
import org.tizen.common.verrari.template.CommonTemplate;
import org.tizen.common.verrari.template.InMemoryTemplate;
import org.tizen.common.verrari.template.Mapper;
import org.tizen.common.verrari.template.TemplateConstants;
import org.tizen.common.verrari.template.TemplateManager;
import org.tizen.common.verrari.util.BufferFactory;

public class DirectoryTemplate
extends CommonTemplate {
    protected String templateRootPath = null;
    protected File templateRootFile = null;

    public DirectoryTemplate(String path) throws TemplateException {
        this(new File(path));
    }

    public DirectoryTemplate(File file) throws TemplateException {
        if (file == null || !file.isDirectory() || StringUtil.isEmpty((CharSequence)file.getAbsolutePath())) {
            throw new TemplateException();
        }
        this.templateRootFile = file;
        this.templateRootPath = this.templateRootFile.getAbsolutePath();
    }

    protected InputStream getInputStream(File file) throws IOException {
        return new FileInputStream(file);
    }

    protected void templateManifest(InputStream in, IModelProvider models) throws IOException, TemplateException {
        ITemplateEngine engine = TemplateEngineFactory.getInstance().create();
        TemplateManager templates = new TemplateManager();
        engine.setTemplateProvider((ITemplateProvider)templates);
        InMemoryTemplate manifestTemplate = new InMemoryTemplate(IOUtil.getBytes((InputStream)in), "utf-8", (FactoryWithArgument)BufferFactory.getInstance());
        templates.addTemplate("MANIFEST.MF", (ITemplate)manifestTemplate);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream is = null;
        try {
            try {
                engine.generate("MANIFEST.MF", models, (OutputStream)out);
                is = new ByteArrayInputStream(out.toByteArray());
                this.loadAttribute(is);
            }
            catch (Exception e) {
                throw new TemplateException(e.getCause());
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{in, out, is});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{in, out, is});
    }

    protected void loadBundleRecursively(File root) throws IOException {
        block10: {
            File[] lists = root.listFiles();
            if (lists == null) break block10;
            File[] fileArray = lists;
            int n = lists.length;
            int n2 = 0;
            while (n2 < n) {
                block11: {
                    InputStream in;
                    String name;
                    File file;
                    block9: {
                        file = fileArray[n2];
                        if (file.isDirectory()) {
                            this.loadBundleRecursively(file);
                        } else {
                            name = file.getName();
                            in = null;
                            if (file.getParentFile() != null && "META-INF".equals(file.getParentFile().getName())) break block9;
                            IOUtil.tryClose((Object[])new Object[]{in});
                        }
                        break block11;
                    }
                    try {
                        if ("messages.properties".equals(name)) {
                            in = this.getInputStream(file);
                            this.defaultBundle = new PropertyResourceBundle(in);
                        } else if (name.startsWith("messages_") && name.endsWith(".properties")) {
                            String localeStr = name.substring("messages_".length(), name.length() - ".properties".length());
                            Object[] fragments = StringUtil.split((String)localeStr, (String)"_");
                            String lang = (String)ArrayUtil.pickupFirst((Object[])fragments);
                            String country = 2 == fragments.length ? fragments[1] : "";
                            Locale locale = new Locale(lang, country);
                            in = this.getInputStream(file);
                            PropertyResourceBundle bundle = new PropertyResourceBundle(in);
                            this.bundles.put(locale, bundle);
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtil.tryClose((Object[])new Object[]{in});
                        throw throwable;
                    }
                    IOUtil.tryClose((Object[])new Object[]{in});
                }
                ++n2;
            }
        }
    }

    protected void loadManifestRecursively(File root, IModelProvider models) throws IOException, TemplateException {
        File[] lists = root.listFiles();
        if (lists != null) {
            File[] fileArray = lists;
            int n = lists.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    this.loadManifestRecursively(file, models);
                } else {
                    String name = file.getName();
                    if (file.getParentFile() != null && "META-INF".equals(file.getParentFile().getName()) && "MANIFEST.MF".equals(name)) {
                        InputStream fin = null;
                        try {
                            fin = this.getInputStream(file);
                            this.templateManifest(fin, models);
                        }
                        catch (Throwable throwable) {
                            IOUtil.tryClose((Object[])new Object[]{fin});
                            throw throwable;
                        }
                        IOUtil.tryClose((Object[])new Object[]{fin});
                    }
                }
                ++n2;
            }
        }
    }

    public void loadManifestRecursively(File root) throws IOException, TemplateException {
        File[] lists = root.listFiles();
        if (lists != null) {
            File[] fileArray = lists;
            int n = lists.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    this.loadManifestRecursively(file);
                } else {
                    String name = file.getName();
                    if (file.getParentFile() != null && "META-INF".equals(file.getParentFile().getName()) && "MANIFEST.MF".equals(name)) {
                        InputStream fin = null;
                        try {
                            fin = this.getInputStream(file);
                            this.loadAttribute(fin);
                        }
                        catch (Throwable throwable) {
                            IOUtil.tryClose((Object[])new Object[]{fin});
                            throw throwable;
                        }
                        IOUtil.tryClose((Object[])new Object[]{fin});
                    }
                }
                ++n2;
            }
        }
    }

    protected void addTemplateRecursively(File root, TemplateManager templates, Filter templateFilter, Filter copyFilter) throws IOException {
        block9: {
            File[] lists = root.listFiles();
            if (lists == null) break block9;
            File[] fileArray = lists;
            int n = lists.length;
            int n2 = 0;
            while (n2 < n) {
                block10: {
                    InputStream in;
                    String name;
                    block8: {
                        block7: {
                            File file = fileArray[n2];
                            if (file.isDirectory()) {
                                this.addTemplateRecursively(file, templates, templateFilter, copyFilter);
                            } else {
                                String relativePath;
                                name = relativePath = file.getAbsolutePath().replace(String.valueOf(this.templateRootPath) + System.getProperty("file.separator"), "");
                                this.logger.trace("Name :{}", (Object)name);
                                in = null;
                                in = this.getInputStream(file);
                                byte[] contents = IOUtil.getBytes((InputStream)in);
                                templates.addTemplate(name, (ITemplate)new InMemoryTemplate(contents, "utf-8", (FactoryWithArgument)BufferFactory.getInstance()));
                                if (!copyFilter.accept("/", OSChecker.isWindows() ? name.replace(System.getProperty("file.separator"), "/") : name)) break block7;
                                this.logger.debug("{} is copy target", (Object)name);
                                this.copyNames.add(name);
                                IOUtil.tryClose((Object[])new Object[]{in});
                            }
                            break block10;
                        }
                        try {
                            if (templateFilter.accept("/", OSChecker.isWindows() ? name.replace(System.getProperty("file.separator"), "/") : name)) break block8;
                            this.logger.info("{} filtered", (Object)name);
                        }
                        catch (Throwable throwable) {
                            IOUtil.tryClose((Object[])new Object[]{in});
                            throw throwable;
                        }
                        IOUtil.tryClose((Object[])new Object[]{in});
                        break block10;
                    }
                    this.templateNames.add(name);
                    IOUtil.tryClose((Object[])new Object[]{in});
                }
                ++n2;
            }
        }
    }

    protected void preload(File rootFile, IModelProvider models) throws IOException, TemplateException {
        context.set(this);
        this.loadBundleRecursively(rootFile);
        this.loadManifestRecursively(rootFile, models);
    }

    protected void load(File rootFile) throws TemplateException, IOException {
        this.engine = TemplateEngineFactory.getInstance().create();
        TemplateManager templates = new TemplateManager();
        String excludes = (String)this.attrs.get("Tizen-Template-Exclude");
        String includes = (String)this.attrs.get("Tizen-Template-Include");
        String copies = (String)this.attrs.get("Tizen-Template-Copy");
        String mappings = (String)this.attrs.get("Tizen-Template-Mapping");
        this.mapper = this.getMapper((String)this.attrs.get("Tizen-Template-Mapper"), mappings);
        Filter templateFilter = this.createFilter(JarRealm.separate(includes), JarRealm.separate(excludes));
        Filter copyFilter = this.createFilter(JarRealm.separate(copies), null);
        this.addTemplateRecursively(rootFile, templates, templateFilter, copyFilter);
        this.engine.setTemplateProvider((ITemplateProvider)templates);
    }

    protected void pretemplate(IModelProvider models) throws IOException, TemplateException {
        this.preload(this.templateRootFile, models);
        this.load(this.templateRootFile);
    }

    @Override
    public void template(IModelProvider models, Storage storage) throws TemplateException {
        this.logger.info("Start template process...");
        System.out.println("Start template process...");
        try {
            try {
                String target;
                this.pretemplate(models);
                ITemplateProvider provider = this.engine.getTemplateProvider();
                if (provider != null) {
                    for (String name : this.copyNames) {
                        this.logger.trace("Copy[{}] start", (Object)name);
                        target = StringUtil.nvl((String[])new String[]{this.mapper.map(OSChecker.isWindows() ? name.replace(System.getProperty("file.separator"), "/") : name), name});
                        ITemplate template = provider.getTemplate(name);
                        if (template == null) continue;
                        InputStream in = null;
                        OutputStream out = null;
                        try {
                            in = template.open();
                            out = storage.getTarget(target);
                            ExecutionContext.getCurrentContext().getPrompter().notify(String.valueOf(target) + " created");
                            IOUtil.redirect((InputStream)in, (OutputStream)out);
                        }
                        catch (Throwable throwable) {
                            IOUtil.tryClose((Object[])new Object[]{in, out});
                            throw throwable;
                        }
                        IOUtil.tryClose((Object[])new Object[]{in, out});
                    }
                }
                for (String name : this.templateNames) {
                    this.logger.trace("Template[{}] start", (Object)name);
                    target = StringUtil.nvl((String[])new String[]{this.mapper.map(OSChecker.isWindows() ? name.replace(System.getProperty("file.separator"), "/") : name), name});
                    OutputStream out = storage.getTarget(target);
                    try {
                        this.engine.generate(name, models, out);
                        ExecutionContext.getCurrentContext().getPrompter().notify(String.valueOf(target) + " created");
                    }
                    catch (Throwable throwable) {
                        IOUtil.tryClose((Object[])new Object[]{out});
                        throw throwable;
                    }
                    IOUtil.tryClose((Object[])new Object[]{out});
                }
            }
            catch (IOException e) {
                throw new TemplateException((Throwable)e);
            }
            catch (Exception e) {
                throw new TemplateException((Throwable)e);
            }
        }
        finally {
            context.remove();
            this.logger.info("End template process...");
        }
    }

    @Override
    protected Mapper getMapper(String mapperName, String mappings) throws InvalidMapperException {
        String safeMapperName = StringUtil.nvl((String[])new String[]{mapperName, TemplateConstants.DV_MAPPER});
        Mapper mapper = (Mapper)ReflectionUtil.tryNewInstance((String)safeMapperName);
        if (mapper == null) {
            throw new InvalidMapperException("'" + safeMapperName + "' is invalide. check your class or config");
        }
        HashMap<String, String> mappingMap = new HashMap<String, String>();
        if (mappings != null) {
            String[] mappingList;
            String[] stringArray = mappingList = CommonRealm.separate(mappings);
            int n = mappingList.length;
            int n2 = 0;
            while (n2 < n) {
                String mapping = stringArray[n2];
                BufferedReader reader = new BufferedReader(new StringReader(mapping));
                String line = null;
                try {
                    try {
                        while ((line = reader.readLine()) != null) {
                            String[] args = line.split(" -> ");
                            mappingMap.put(args[0], args[1]);
                        }
                    }
                    catch (IOException iOException) {
                        throw new IllegalStateException("Unreachable block");
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.tryClose((Object[])new Object[]{reader});
                    throw throwable;
                }
                IOUtil.tryClose((Object[])new Object[]{reader});
                ++n2;
            }
        }
        mapper.setMappings(mappingMap);
        return mapper;
    }
}

