/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.ui.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.tizen.common.rest.RestPlugin;
import org.tizen.common.rest.RestUIMessages;
import org.tizen.common.rest.ui.preferences.AbstractAuthPreference;

public class ApiKeyAuthPreference
extends AbstractAuthPreference {
    public static final String ID_PREFERENCE = "org.tizen.common.rest.apiKeyAuthType";
    public static final String TITLE_RADIO_HEADER = "Header";
    public static final String TITLE_RADIO_PARAMETER = "Parameter";
    public static IPreferenceStore store;
    private Button radioHeader;
    private Button radioParam;
    private Text textKey;
    private Text textValue;
    private Composite container;

    public ApiKeyAuthPreference() {
        store = RestPlugin.getDefault().getPreferenceStore();
    }

    @Override
    public String getID() {
        return ID_PREFERENCE;
    }

    @Override
    public Composite createContentArea(Composite parent) {
        int nColumns = 2;
        this.container = this.createComposite(parent, nColumns);
        GridData gd = new GridData(768);
        this.container.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        this.container.setLayout((Layout)layout);
        Composite composite = this.createComposite(this.container, nColumns);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        composite.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.createLabel(composite, RestUIMessages.ApiKeyAuthPreference_payload_type_label);
        this.radioHeader = this.createRadioButton(composite, TITLE_RADIO_HEADER, "PREF_KEY_AUTH_API_KEY_PAYLOAD", TITLE_RADIO_HEADER);
        this.radioHeader.setSelection(true);
        this.radioParam = this.createRadioButton(composite, TITLE_RADIO_PARAMETER, "PREF_KEY_AUTH_API_KEY_PAYLOAD", TITLE_RADIO_PARAMETER);
        this.createLabel(this.container, RestUIMessages.ApiKeyAuthPreference_name_label);
        this.textKey = this.createText(this.container, 0, 1);
        this.createLabel(this.container, RestUIMessages.ApiKeyAuthPreference_value_label);
        this.textValue = this.createText(this.container, 0, 1);
        return this.container;
    }

    @Override
    public void loadData(String appId) {
        String payload = this.getValue(store, "PREF_KEY_AUTH_API_KEY_PAYLOAD", appId);
        String keyName = this.getValue(store, "PREF_KEY_AUTH_API_KEY_NAME", appId);
        String keyValue = this.getValue(store, "PREF_KEY_AUTH_API_KEY_VALUE", appId);
        boolean paramSelected = TITLE_RADIO_PARAMETER.equals(payload);
        this.radioHeader.setSelection(!paramSelected);
        this.radioParam.setSelection(paramSelected);
        this.textKey.setText(keyName);
        this.textValue.setText(keyValue);
    }

    @Override
    public void performApply(String appId) {
        boolean paramSelected = this.radioParam.getSelection();
        String keyName = this.textKey.getText();
        String keyValue = this.textValue.getText();
        this.setValue(store, "PREF_KEY_AUTH_API_KEY_PAYLOAD", paramSelected ? TITLE_RADIO_PARAMETER : TITLE_RADIO_HEADER, appId);
        this.setValue(store, "PREF_KEY_AUTH_API_KEY_NAME", keyName, appId);
        this.setValue(store, "PREF_KEY_AUTH_API_KEY_VALUE", keyValue, appId);
    }

    @Override
    public void performDefaults(String appId) {
        String payload = this.getDefault(store, "PREF_KEY_AUTH_API_KEY_PAYLOAD", appId);
        String keyName = this.getDefault(store, "PREF_KEY_AUTH_API_KEY_NAME", appId);
        String keyValue = this.getDefault(store, "PREF_KEY_AUTH_API_KEY_VALUE", appId);
        boolean paramSelected = TITLE_RADIO_PARAMETER.equals(payload);
        this.radioHeader.setSelection(!paramSelected);
        this.radioParam.setSelection(paramSelected);
        this.textKey.setText(keyName);
        this.textValue.setText(keyValue);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.recursiveSetEnabled((Control)this.container, enabled);
    }
}

