/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.autoemul.wizard;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.tizen.common.autoemul.DeviceEntryManager;
import org.tizen.common.autoemul.messages.AutoEmulMessages;
import org.tizen.common.autoemul.wizard.AutoEmulDialogPage;
import org.tizen.common.autoemul.wizard.AutoEmulWizard;
import org.tizen.common.util.OSChecker;

public class AutoEmulGenWizardDialog
extends WizardDialog {
    private Composite parent;
    private int x = 0;
    private int y = 0;
    private final int width = OSChecker.isWindows() ? 485 : 555;
    private final int height = 450;
    public static String selectionDeviceName = "";
    private Shell shell;
    private Button btnEmulatorManager;
    private Button finish;
    private Button btnRefreshList;
    private Button cancel;

    public AutoEmulGenWizardDialog(Shell parentShell, IWizard newWizard) {
        super(parentShell, newWizard);
        Rectangle bounds = null;
        bounds = parentShell.getBounds();
        this.setbounds(bounds);
        this.setShellStyle(96);
    }

    public void setbounds(Rectangle bounds) {
        this.x = bounds.x + (bounds.width - this.width) / 2;
        this.y = bounds.y + (bounds.height - 450) / 2;
    }

    public static void selectionDeviceName(String selDeviceName) {
        selectionDeviceName = selDeviceName;
    }

    public static String getSelectionDeviceName() {
        return selectionDeviceName;
    }

    public void setFocusBtnEmulatorManager() {
        this.btnEmulatorManager.setFocus();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        this.shell = newShell;
        newShell.setLocation(this.x, this.y);
        newShell.setSize(this.width, 450);
    }

    protected void PressedFinished() {
        super.finishPressed();
    }

    protected void createButtonsForButtonBar(Composite p) {
        this.parent = p;
        super.createButtonsForButtonBar(this.parent);
        int EMULATOR_MANAGER_BUTTON_ID = 101;
        int REFRESH_BUTTON_ID = 1;
        String EMULATOR_MANAGER_BUTTON_LABEL = "Emulator Manager";
        String REFRESH_BUTTON_LABEL = "Refresh";
        String LAUNCHER_LABEL = "Launch";
        this.finish = this.getButton(16);
        this.finish.setText(LAUNCHER_LABEL);
        this.finish.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.setButtonLayoutData(this.finish);
        this.btnEmulatorManager = this.createButton(this.parent, EMULATOR_MANAGER_BUTTON_ID, EMULATOR_MANAGER_BUTTON_LABEL, true);
        this.btnEmulatorManager.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeviceEntryManager.getDeviceEntryManager().runEmulatorManager();
            }
        });
        this.setButtonLayoutData(this.btnEmulatorManager);
        this.btnRefreshList = this.createButton(this.parent, REFRESH_BUTTON_ID, REFRESH_BUTTON_LABEL, true);
        this.btnRefreshList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AutoEmulWizard wizard = (AutoEmulWizard)AutoEmulGenWizardDialog.this.getWizard();
                AutoEmulDialogPage deviceDialog = (AutoEmulDialogPage)wizard.getContainer().getCurrentPage();
                boolean isSuccessfulUpdate = DeviceEntryManager.doUpdateDeviceList();
                if (isSuccessfulUpdate) {
                    deviceDialog.tableViewer.setInput(DeviceEntryManager.getOldDeviceList());
                    deviceDialog.tableViewer.refresh();
                    if (DeviceEntryManager.getOldDeviceList().size() == 0) {
                        deviceDialog.setDescription(AutoEmulMessages.SELECT_EMULATOR_INFO_EMPTYLIST);
                    } else {
                        deviceDialog.setDescription(AutoEmulMessages.SELECT_EMULATOR_DEFAULT_DESCRIPTION);
                        deviceDialog.tableViewer.setSelection((ISelection)new StructuredSelection(deviceDialog.tableViewer.getElementAt(0)), true);
                    }
                    wizard.canFinish();
                    wizard.getContainer().updateButtons();
                } else {
                    MessageDialog.openInformation((Shell)AutoEmulGenWizardDialog.this.shell, (String)"Information", (String)AutoEmulMessages.SELECT_EMULATOR_REFRESH_NOUPDATE);
                }
            }
        });
        this.setButtonLayoutData(this.btnRefreshList);
        this.btnEmulatorManager.moveAbove((Control)this.finish);
        this.btnRefreshList.moveAbove((Control)this.finish);
        this.cancel = this.getButton(1);
        this.cancel.moveAbove((Control)this.finish);
    }
}

