/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.header;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class Header
extends Composite {
    private Image image;
    private String title;
    private String description;
    private Font titleFont;
    private Color titleColor;
    private Image oldImage;
    private Color gradientEnd;
    private Color gradientStart;
    private Color separatorColor;

    public Header(Composite parent, int style) {
        super(parent, style);
        FontData[] fontData = this.getFont().getFontData();
        if (fontData != null && fontData.length > 0) {
            FontData fd = fontData[0];
            fd.setStyle(1);
            fd.setHeight(fd.getHeight() + 2);
            this.titleFont = new Font((Device)this.getDisplay(), fd);
        } else {
            this.titleFont = null;
        }
        this.titleColor = new Color((Device)this.getDisplay(), 0, 88, 150);
        this.gradientEnd = new Color((Device)this.getDisplay(), 239, 239, 239);
        this.gradientStart = new Color((Device)this.getDisplay(), 255, 255, 255);
        this.separatorColor = new Color((Device)this.getDisplay(), 229, 229, 229);
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Header.this.redrawComposite();
            }
        });
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                SWTGraphicUtil.dispose((Resource)Header.this.titleColor);
                SWTGraphicUtil.dispose((Resource)Header.this.titleFont);
                SWTGraphicUtil.dispose((Resource)Header.this.oldImage);
                SWTGraphicUtil.dispose((Resource)Header.this.gradientEnd);
                SWTGraphicUtil.dispose((Resource)Header.this.gradientStart);
                SWTGraphicUtil.dispose((Resource)Header.this.separatorColor);
            }
        });
        this.setBackgroundMode(2);
    }

    private void redrawComposite() {
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        int numberOfColumns = 1;
        if (this.image != null) {
            ++numberOfColumns;
        }
        super.setLayout((Layout)new GridLayout(numberOfColumns, false));
        this.createContent();
        this.drawBackground();
    }

    private void createContent() {
        if (this.title != null) {
            this.createTitle();
        }
        if (this.image != null) {
            this.createImage();
        }
        if (this.description != null) {
            this.createDescription();
        }
    }

    private void createTitle() {
        Label labelTitle = new Label((Composite)this, 0);
        labelTitle.setLayoutData((Object)new GridData(4, 1, true, false));
        labelTitle.setFont(this.titleFont);
        labelTitle.setForeground(this.titleColor);
        labelTitle.setText(this.title);
    }

    private void createImage() {
        int numberOfLines = 1;
        if (this.title != null && this.description != null) {
            ++numberOfLines;
        }
        Label labelImage = new Label((Composite)this, 0);
        labelImage.setLayoutData((Object)new GridData(4, 1, false, true, 1, numberOfLines));
        labelImage.setImage(this.image);
    }

    private void createDescription() {
        StyledText labelDescription = new StyledText((Composite)this, 72);
        labelDescription.setLayoutData((Object)new GridData(4, 4, true, true));
        labelDescription.setEnabled(false);
        labelDescription.setFont(this.getFont());
        labelDescription.setForeground(this.getForeground());
        labelDescription.setText("<html><body>" + this.description + "</body></html>");
        SWTGraphicUtil.applyHTMLFormating(labelDescription);
    }

    private void drawBackground() {
        Display display = this.getDisplay();
        Rectangle rect = this.getClientArea();
        Image newImage = new Image((Device)display, Math.max(1, rect.width), Math.max(1, rect.height));
        GC gc = new GC((Drawable)newImage);
        gc.setForeground(this.gradientStart);
        gc.setBackground(this.gradientEnd);
        gc.fillGradientRectangle(rect.x, rect.y, rect.width, rect.height, false);
        gc.setForeground(this.separatorColor);
        gc.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width, rect.y + rect.height - 1);
        gc.dispose();
        this.setBackgroundImage(newImage);
        if (this.oldImage != null) {
            this.oldImage.dispose();
        }
        this.oldImage = newImage;
    }

    public void setLayout(Layout layout) {
        throw new UnsupportedOperationException("Not supported");
    }

    public String getDescription() {
        this.checkWidget();
        return this.description;
    }

    public Color getGradientEnd() {
        this.checkWidget();
        return this.gradientEnd;
    }

    public Color getGradientStart() {
        this.checkWidget();
        return this.gradientStart;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public Color getSeparatorColor() {
        this.checkWidget();
        return this.separatorColor;
    }

    public String getTitle() {
        this.checkWidget();
        return this.title;
    }

    public Color getTitleColor() {
        this.checkWidget();
        return this.titleColor;
    }

    public Font getTitleFont() {
        this.checkWidget();
        return this.titleFont;
    }

    public void setDescription(String description) {
        this.checkWidget();
        this.description = description;
    }

    public void setGradientEnd(Color gradientEnd) {
        this.checkWidget();
        this.gradientEnd = gradientEnd;
    }

    public void setGradientStart(Color gradientStart) {
        this.checkWidget();
        this.gradientStart = gradientStart;
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.image = image;
    }

    public void setSeparatorColor(Color separatorColor) {
        this.separatorColor = separatorColor;
    }

    public void setTitle(String title) {
        this.checkWidget();
        this.title = title;
    }

    public void setTitleColor(Color headerColor) {
        this.checkWidget();
        this.titleColor = headerColor;
    }

    public void setTitleFont(Font headerFont) {
        this.checkWidget();
        this.titleFont = headerFont;
    }
}

