/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.tipOfTheDay;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.mihalis.opal.header.Header;
import org.mihalis.opal.utils.ResourceManager;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class TipOfTheDay {
    private final List<String> tips = new ArrayList<String>();
    private boolean displayShowOnStartup = true;
    private boolean showOnStartup = true;
    private Shell shell;
    private Button close;
    private int index = -1;
    protected Browser tipArea;
    private String fontName;
    private TipStyle style;
    private Image image;

    public TipOfTheDay() {
        Font temp = Display.getDefault().getSystemFont();
        FontData[] fontData = temp.getFontData();
        this.fontName = fontData != null && fontData.length > 0 ? fontData[0].getName() : "Arial";
        this.style = TipStyle.TWO_COLUMNS;
    }

    public void open(Shell parent) {
        if (this.index == -1) {
            this.index = new Random().nextInt(this.tips.size());
        }
        this.buildShell(parent);
        if (this.style == TipStyle.HEADER) {
            this.buildHeader();
        } else {
            this.buildLeftColumn();
        }
        this.buildTip();
        this.buildButtons();
        this.openShell();
    }

    private void buildShell(Shell parent) {
        this.shell = new Shell(parent, 133232);
        this.shell.setText(ResourceManager.getLabel("tipOfTheDay"));
        this.shell.setLayout((Layout)new GridLayout(this.style == TipStyle.HEADER ? 1 : 2, false));
        this.shell.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 2: {
                        TipOfTheDay.this.shell.dispose();
                        event.detail = 0;
                        event.doit = false;
                        break;
                    }
                }
            }
        });
    }

    private void buildHeader() {
        Header header = new Header((Composite)this.shell, 0);
        GridData gd = new GridData(4, 1, true, false);
        gd.heightHint = 80;
        header.setLayoutData(gd);
        header.setTitle(ResourceManager.getLabel("didYouKnow"));
        if (this.image == null) {
            final Image img = SWTGraphicUtil.createImage("images/light2.png");
            header.setImage(img);
            this.shell.addListener(12, new Listener(){

                public void handleEvent(Event event) {
                    img.dispose();
                }
            });
        } else {
            header.setImage(this.image);
        }
    }

    private void buildLeftColumn() {
        Composite composite = new Composite((Composite)this.shell, 0);
        int numberOfRows = 1;
        if (this.style == TipStyle.TWO_COLUMNS_LARGE) {
            numberOfRows = this.displayShowOnStartup ? 5 : 4;
        }
        GridData gd = new GridData(4, 1, false, true, 1, numberOfRows);
        composite.setLayoutData((Object)gd);
        FillLayout compositeLayout = new FillLayout();
        compositeLayout.marginWidth = 2;
        composite.setLayout((Layout)compositeLayout);
        Label label = new Label(composite, 0);
        if (this.image == null) {
            final Image img = SWTGraphicUtil.createImage("images/light1.png");
            label.setImage(img);
            this.shell.addListener(12, new Listener(){

                public void handleEvent(Event event) {
                    img.dispose();
                }
            });
        } else {
            label.setImage(this.image);
        }
    }

    private void buildTip() {
        if (this.style == TipStyle.TWO_COLUMNS) {
            Group group = new Group((Composite)this.shell, 0);
            GridData gd = new GridData(4, 4, true, true);
            gd.widthHint = 300;
            gd.heightHint = 120;
            group.setLayoutData((Object)gd);
            group.setText(ResourceManager.getLabel("didYouKnow"));
            FillLayout fillLayout = new FillLayout();
            fillLayout.marginWidth = 15;
            group.setLayout((Layout)fillLayout);
            this.tipArea = new Browser((Composite)group, 2048);
        } else if (this.style == TipStyle.TWO_COLUMNS_LARGE) {
            Label title = new Label((Composite)this.shell, 0);
            GridData gd = new GridData(4, 4, true, false);
            gd.verticalIndent = 15;
            title.setLayoutData((Object)gd);
            final Font tempFont = SWTGraphicUtil.buildFontFrom((Control)title, 1, 16);
            title.setText(ResourceManager.getLabel("tipOfTheDay"));
            title.setFont(tempFont);
            this.shell.addListener(12, new Listener(){

                public void handleEvent(Event event) {
                    tempFont.dispose();
                }
            });
            Label separator = new Label((Composite)this.shell, 258);
            separator.setLayoutData((Object)new GridData(4, 4, true, false));
            this.tipArea = new Browser((Composite)this.shell, 2048);
            GridData gdTipArea = new GridData(4, 4, true, true);
            gdTipArea.heightHint = 120;
            this.tipArea.setLayoutData((Object)gdTipArea);
        } else {
            this.tipArea = new Browser((Composite)this.shell, 2048);
            GridData gd = new GridData(4, 4, true, true);
            gd.heightHint = 500;
            gd.widthHint = 700;
            this.tipArea.setLayoutData((Object)gd);
        }
        this.fillTipArea();
    }

    protected void fillTipArea() {
        this.tipArea.setText("<html><body bgcolor=\"#ffffff\" text=\"#000000\"><p style=\"font-family:" + this.fontName + ";font-size=12px\">" + this.tips.get(this.index) + "</p></body></html>");
    }

    private void buildButtons() {
        GridData gridClose;
        GridData gridNext;
        GridData gridPrevious;
        GridData gridShowOnStartup;
        Composite composite = new Composite((Composite)this.shell, 0);
        int numberOfColumns = this.style == TipStyle.HEADER ? 1 : (this.style == TipStyle.TWO_COLUMNS ? 2 : 1);
        GridData gd = new GridData(4, 1, false, false, numberOfColumns, 1);
        composite.setLayoutData((Object)gd);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 2;
        if (this.style == TipStyle.TWO_COLUMNS_LARGE) {
            composite.setLayout((Layout)new GridLayout(3, false));
        } else {
            composite.setLayout((Layout)new GridLayout(this.displayShowOnStartup ? 4 : 3, false));
        }
        if (this.style == TipStyle.TWO_COLUMNS_LARGE) {
            gridShowOnStartup = new GridData(1, 1, true, false, 3, 1);
            gridPrevious = new GridData(3, 2, true, false);
            gridPrevious.widthHint = 120;
            gridNext = new GridData(2, 2, false, false);
            gridNext.widthHint = 120;
            gridClose = new GridData(1, 2, true, false);
            gridClose.widthHint = 120;
        } else {
            gridShowOnStartup = new GridData(1, 2, true, false);
            gridPrevious = new GridData(3, 2, !this.showOnStartup, false);
            gridPrevious.widthHint = 120;
            gridNext = new GridData(4, 2, false, false);
            gridNext.widthHint = 120;
            gridClose = new GridData(4, 2, false, false);
            gridClose.widthHint = 120;
        }
        if (this.displayShowOnStartup) {
            this.buildShowOnStartup(composite, gridShowOnStartup);
        }
        this.buildPreviousButton(composite, gridPrevious);
        this.buildNextButton(composite, gridNext);
        this.buildCloseButton(composite, gridClose);
    }

    protected void buildShowOnStartup(Composite composite, GridData gridData) {
        final Button checkBox = new Button(composite, 32);
        checkBox.setLayoutData((Object)gridData);
        checkBox.setText(ResourceManager.getLabel("showTipAtStartup"));
        checkBox.setSelection(this.showOnStartup);
        checkBox.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TipOfTheDay.this.showOnStartup = checkBox.getSelection();
            }
        });
    }

    private void buildPreviousButton(Composite composite, GridData gridData) {
        Button previous = new Button(composite, 8);
        previous.setText(ResourceManager.getLabel("previousTip"));
        previous.setLayoutData((Object)gridData);
        previous.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TipOfTheDay.this.index == 0) {
                    TipOfTheDay.this.setIndex(TipOfTheDay.this.tips.size() - 1);
                } else {
                    TipOfTheDay.this.setIndex(TipOfTheDay.this.index - 1);
                }
            }
        });
    }

    private void buildNextButton(Composite composite, GridData gridData) {
        Button next = new Button(composite, 8);
        next.setText(ResourceManager.getLabel("nextTip"));
        next.setLayoutData((Object)gridData);
        next.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TipOfTheDay.this.index == TipOfTheDay.this.tips.size() - 1) {
                    TipOfTheDay.this.setIndex(0);
                } else {
                    TipOfTheDay.this.setIndex(TipOfTheDay.this.index + 1);
                }
            }
        });
    }

    private void buildCloseButton(Composite composite, GridData gridData) {
        this.close = new Button(composite, 8);
        this.close.setText(ResourceManager.getLabel("Close"));
        this.close.setLayoutData((Object)gridData);
        this.close.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TipOfTheDay.this.shell.dispose();
            }
        });
    }

    private void openShell() {
        this.shell.setDefaultButton(this.close);
        this.shell.pack();
        this.shell.open();
        SWTGraphicUtil.centerShell(this.shell);
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    public TipOfTheDay addTip(String tip) {
        this.tips.add(tip);
        return this;
    }

    public Image getImage() {
        return this.image;
    }

    public int getIndex() {
        return this.index;
    }

    public TipStyle getStyle() {
        return this.style;
    }

    public List<String> getTips() {
        return this.tips;
    }

    public boolean isDisplayShowOnStartup() {
        return this.displayShowOnStartup;
    }

    public boolean isShowOnStartup() {
        return this.showOnStartup;
    }

    public void setDisplayShowOnStartup(boolean displayShowOnStartup) {
        this.displayShowOnStartup = displayShowOnStartup;
    }

    public void setIndex(int index) {
        if (index < 0 || index >= this.tips.size() || this.tips.get(index) == null) {
            throw new IllegalArgumentException("Index should be between 0 and " + (this.tips.size() - 1) + " (entered value:" + index + ")");
        }
        this.index = index;
        if (this.tipArea != null && !this.tipArea.isDisposed()) {
            this.fillTipArea();
        }
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setShowOnStartup(boolean showOnStartup) {
        this.showOnStartup = showOnStartup;
    }

    public void setStyle(TipStyle style) {
        this.style = style;
    }

    public static enum TipStyle {
        TWO_COLUMNS,
        TWO_COLUMNS_LARGE,
        HEADER;

    }
}

