/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib.service;

import org.tizen.sdblib.service.SyncServiceReturnCode;
import org.tizen.sdblib.util.Assert;

public class SyncResult {
    protected final int code;
    protected final String message;

    protected static String errorCodeToString(int code) {
        String message = SyncServiceReturnCode.getMessage(code);
        Assert.notNull(message);
        return message;
    }

    public SyncResult(int code) {
        this(code, SyncResult.errorCodeToString(code));
    }

    public SyncResult(int code, String message) {
        this.code = code;
        this.message = message;
    }

    SyncResult(int code, Exception e) {
        this.code = code;
        String errorMessage = SyncResult.errorCodeToString(code);
        String exceptionMessage = e.getMessage();
        this.message = exceptionMessage != null ? String.valueOf(errorMessage) + "\n" + exceptionMessage : errorMessage;
    }

    public SyncResult() {
        this(SyncServiceReturnCode.RESULT_OK);
    }

    public SyncResult(SyncServiceReturnCode code) {
        this(code.value());
    }

    public SyncResult(SyncServiceReturnCode code, String message) {
        this(code.value(), message);
    }

    SyncResult(SyncServiceReturnCode code, Exception e) {
        this(code.value(), e);
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isOk() {
        return SyncServiceReturnCode.RESULT_OK.value() == this.getCode();
    }
}

