/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.model.run;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IElementComparer;
import org.tizen.common.rest.model.run.RunHistory;

public final class AdvancedTreePath {
    public static final AdvancedTreePath EMPTY = new AdvancedTreePath(new RunHistory[0]);
    private RunHistory[] segments;
    private int hash;

    public AdvancedTreePath(RunHistory[] segments) {
        Assert.isNotNull((Object)segments);
        int i = 0;
        while (i < segments.length) {
            Assert.isNotNull((Object)segments[i]);
            ++i;
        }
        this.segments = segments;
    }

    public RunHistory getSegment(int index) {
        return this.segments[index];
    }

    public int getSegmentCount() {
        return this.segments.length;
    }

    public RunHistory getFirstSegment() {
        if (this.segments.length == 0) {
            return null;
        }
        return this.segments[0];
    }

    public RunHistory getLastSegment() {
        if (this.segments.length == 0) {
            return null;
        }
        return this.segments[this.segments.length - 1];
    }

    public boolean equals(Object other) {
        if (!(other instanceof AdvancedTreePath)) {
            return false;
        }
        return this.equals((AdvancedTreePath)other, null);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.hashCode(null);
        }
        return this.hash;
    }

    public int hashCode(IElementComparer comparer) {
        int result = 0;
        int i = 0;
        while (i < this.segments.length) {
            result = comparer == null ? (result += this.segments[i].hashCode()) : (result += comparer.hashCode((Object)this.segments[i]));
            ++i;
        }
        return result;
    }

    public boolean equals(AdvancedTreePath otherPath, IElementComparer comparer) {
        if (otherPath == null) {
            return false;
        }
        if (this.segments.length != otherPath.segments.length) {
            return false;
        }
        int i = 0;
        while (i < this.segments.length) {
            if (comparer == null ? !this.segments[i].equals(otherPath.segments[i]) : !comparer.equals((Object)this.segments[i], (Object)otherPath.segments[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean startsWith(AdvancedTreePath treePath, IElementComparer comparer) {
        int thisSegmentCount = this.getSegmentCount();
        int otherSegmentCount = treePath.getSegmentCount();
        if (otherSegmentCount == thisSegmentCount) {
            return this.equals(treePath, comparer);
        }
        if (otherSegmentCount > thisSegmentCount) {
            return false;
        }
        int i = 0;
        while (i < otherSegmentCount) {
            RunHistory otherSegment = treePath.getSegment(i);
            if (comparer == null ? !otherSegment.equals(this.segments[i]) : !comparer.equals((Object)otherSegment, (Object)this.segments[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public AdvancedTreePath getParentPath() {
        int segmentCount = this.getSegmentCount();
        if (segmentCount < 1) {
            return null;
        }
        if (segmentCount == 1) {
            return EMPTY;
        }
        RunHistory[] parentSegments = new RunHistory[segmentCount - 1];
        System.arraycopy(this.segments, 0, parentSegments, 0, segmentCount - 1);
        return new AdvancedTreePath(parentSegments);
    }

    public AdvancedTreePath createChildPath(RunHistory newSegment) {
        int segmentCount = this.getSegmentCount();
        RunHistory[] childSegments = new RunHistory[segmentCount + 1];
        if (segmentCount > 0) {
            System.arraycopy(this.segments, 0, childSegments, 0, segmentCount);
        }
        childSegments[segmentCount] = newSegment;
        return new AdvancedTreePath(childSegments);
    }
}

