/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.run;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.NameNotFoundException;
import org.apache.http.entity.ContentType;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.tizen.common.rest.RestPlugin;
import org.tizen.common.rest.RestUIMessages;
import org.tizen.common.rest.model.RepositoryManager;
import org.tizen.common.rest.model.run.ResponseModel;
import org.tizen.common.rest.model.run.TestData;
import org.tizen.common.rest.model.schema.Application;
import org.tizen.common.rest.model.schema.Grammars;
import org.tizen.common.rest.model.schema.Method;
import org.tizen.common.rest.model.schema.Representation;
import org.tizen.common.rest.model.schema.Response;
import org.tizen.common.rest.util.ModelUtil;
import org.tizen.common.rest.util.OutputUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResponseDataProcessor {
    public static void saveResponseData(List<TestData> datas) {
        if (datas != null && datas.size() > 0) {
            int i = 0;
            while (i < datas.size()) {
                TestData data = datas.get(i);
                ResponseModel resModel = data.getResponseModel();
                if (200 == resModel.getResponseCode()) {
                    Method method = data.getRequestModel().getApi();
                    method = ModelUtil.findReferences(method);
                    Map<String, String> headers = resModel.getHeaders();
                    if (headers != null) {
                        String contentTypeStr = headers.get("Content-Type");
                        String contents = resModel.getContents();
                        ResponseDataProcessor.saveResponse(contentTypeStr, contents, method);
                    }
                }
                ++i;
            }
            RepositoryManager.getInstance().reloadRepository(true);
        }
    }

    private static void saveResponse(String contentTypeStr, String contents, Method method) {
        boolean exist;
        Element element = null;
        ContentType contentType = ContentType.parse((String)contentTypeStr);
        String mimeType = contentType.getMimeType();
        boolean overwrite = false;
        String resElementName = ResponseDataProcessor.getResponseElementName(method, mimeType);
        boolean bl = exist = resElementName != null && resElementName.length() > 0;
        if (exist) {
            overwrite = ResponseDataProcessor.checkOverwrite(resElementName);
        }
        if (exist && !overwrite) {
            return;
        }
        boolean isJson = false;
        if (ContentType.APPLICATION_JSON.getMimeType().equals(mimeType)) {
            element = ResponseDataProcessor.toSchemaFromJson(contents);
            isJson = true;
        } else if (ContentType.APPLICATION_XML.getMimeType().equals(mimeType)) {
            element = ResponseDataProcessor.toSchemaFromXml(contents);
        }
        if (element != null) {
            try {
                String responseName = ResponseDataProcessor.getResponseName(element);
                String responseId = ResponseDataProcessor.generateResponseId(method, responseName, isJson);
                if (exist && overwrite) {
                    responseId = resElementName;
                }
                ResponseDataProcessor.changeElementName(element, responseId, isJson);
                Application application = method.getRoot();
                Grammars g = ResponseDataProcessor.findOrCreateGrammars(application);
                ResponseDataProcessor.addOrReplaceGrammar(g, element, responseId, overwrite);
                if (!exist) {
                    ResponseDataProcessor.addResponseElementToMethod(method, mimeType, responseId);
                }
                RepositoryManager.getInstance().updateOrAddApplication(application);
            }
            catch (Exception e) {
                String defaultMsg = e.getMessage();
                defaultMsg = String.valueOf(defaultMsg) + "\nResponse contents : \n" + contents;
                Status status = new Status(4, RestPlugin.getPluginId(), defaultMsg, (Throwable)e);
                RestPlugin.log((IStatus)status);
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)RestUIMessages.ResponseDataProcessor_saveResponse_error);
            }
        }
    }

    private static boolean checkOverwrite(String resElementName) {
        boolean overwrite = false;
        IPreferenceStore prefStore = RestPlugin.getDefault().getPreferenceStore();
        boolean alwaysOverwrite = prefStore.getBoolean("PREF_KEY_RES_SAVE_OVERWRITE");
        if (!alwaysOverwrite) {
            MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)Display.getCurrent().getActiveShell(), (String)RestUIMessages.RunPreferencePage_resSave_overwrite_title, (String)MessageFormat.format(RestUIMessages.RunPreferencePage_resSave_overwrite_description, resElementName), (String)RestUIMessages.RunPreferencePage_resSave_toggle, (boolean)alwaysOverwrite, (IPreferenceStore)prefStore, (String)"PREF_KEY_RES_SAVE_OVERWRITE");
            int returnCode = dialog.getReturnCode();
            alwaysOverwrite = dialog.getToggleState();
            if (alwaysOverwrite) {
                prefStore.setValue("PREF_KEY_RES_SAVE_OVERWRITE", alwaysOverwrite);
            }
            overwrite |= returnCode == 2;
        } else {
            overwrite = alwaysOverwrite;
        }
        return overwrite;
    }

    private static String getResponseElementName(Method method, String mimeType) {
        List<Response> resList = method.getResponse();
        for (Response res : resList) {
            List<Representation> repList = res.getRepresentation();
            for (Representation rep : repList) {
                String name = rep.getElement();
                if (name == null || name.length() <= 0 || !mimeType.equals(rep.getMediaType())) continue;
                return name.toString();
            }
        }
        return null;
    }

    private static Element getResponseRootElement(Element element) throws NameNotFoundException {
        NodeList nodeList = element.getElementsByTagName("xsd:element");
        if (nodeList.getLength() == 0) {
            throw new NameNotFoundException("There is no root \"xsd:element\".");
        }
        Element rootEl = (Element)nodeList.item(0);
        return rootEl;
    }

    private static String getResponseName(Element element) throws NameNotFoundException {
        Element rootEl = ResponseDataProcessor.getResponseRootElement(element);
        String name = rootEl.getAttribute("name");
        return name;
    }

    private static String generateResponseId(Method method, String responseName, boolean isJson) {
        String name;
        if (!isJson) {
            return responseName;
        }
        String id = method.getId();
        if (id == null || id.length() == 0) {
            id = Integer.toHexString(method.hashCode());
        }
        if ((name = method.getName()) != null && name.length() > 0) {
            id = String.valueOf(responseName) + "_" + name + "_" + id;
        }
        return id;
    }

    private static void changeElementName(Element element, String responseId, boolean isJson) throws NameNotFoundException {
        if (isJson) {
            Element rootEl = ResponseDataProcessor.getResponseRootElement(element);
            rootEl.setAttribute("name", responseId);
        }
    }

    private static Grammars findOrCreateGrammars(Application application) {
        Grammars g = application.getGrammars();
        if (g == null) {
            g = new Grammars();
        }
        return g;
    }

    private static void addOrReplaceGrammar(Grammars g, Element element, String responseId, boolean replace) throws NameNotFoundException {
        List<Object> anys = g.getAny();
        if (anys.size() > 0) {
            boolean found = false;
            Node rootEl = null;
            for (Object obj : anys) {
                Element subRoot;
                if (!(obj instanceof Element) || (subRoot = OutputUtil.getChildElementByTagNameAndAttribute((Element)(rootEl = (Element)obj), "xsd:element", "name", responseId)) == null) continue;
                found = true;
                if (!replace) break;
                subRoot.getParentNode().removeChild(subRoot);
                break;
            }
            if (!found || replace) {
                if (rootEl != null) {
                    Element e = ResponseDataProcessor.getResponseRootElement(element);
                    Node cloned = rootEl.getOwnerDocument().importNode(e, true);
                    rootEl.appendChild(cloned);
                } else {
                    anys.add(element);
                }
            }
        } else {
            anys.add(element);
        }
    }

    private static void addResponseElementToMethod(Method method, String mimeType, String responseId) {
        List<Response> resList = method.getResponse();
        Representation rep = ResponseDataProcessor.getOrCreateAdaptiveRepresentation(resList, mimeType);
        rep.setElement(responseId);
        rep.setMediaType(mimeType);
    }

    private static Representation getOrCreateAdaptiveRepresentation(List<Response> resList, String contentTypeStr) {
        Response res = null;
        Representation rep = null;
        if (resList.size() == 0) {
            res = new Response();
        } else {
            Iterator<Response> itor = resList.iterator();
            while (itor.hasNext()) {
                List<Representation> repList = itor.next().getRepresentation();
                int i = 0;
                while (i < repList.size()) {
                    Representation r = repList.get(i);
                    if (contentTypeStr.equals(r.getMediaType())) {
                        return r;
                    }
                    ++i;
                }
            }
            res = resList.get(0);
        }
        rep = new Representation();
        res.getRepresentation().add(0, rep);
        return rep;
    }

    private static Element toSchemaFromXml(String contents) {
        System.out.println("##### XML #####");
        System.out.println(String.valueOf(contents) + "\n");
        System.out.println("##### XML -> XSD #####");
        String schemaString = OutputUtil.convertXmlToSchema(contents);
        System.out.println(String.valueOf(schemaString) + "\n");
        Element element = OutputUtil.getDocumentElement(schemaString);
        return element;
    }

    private static Element toSchemaFromJson(String contents) {
        System.out.println("##### JSON #####");
        System.out.println(String.valueOf(contents) + "\n");
        String xml = OutputUtil.toXmlFromJson(contents);
        return ResponseDataProcessor.toSchemaFromXml(xml);
    }
}

