/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.StatusCommand;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.kohsuke.args4j.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Command(usage="usage_Status", common=true)
class Status
extends TextBuiltin {
    protected final String lineFormat;
    protected final String statusFileListFormat;
    protected final String statusFileListFormatWithPrefix;
    protected final String statusFileListFormatUnmerged;
    @Option(name="--", metaVar="metaVar_path", multiValued=true)
    protected List<String> filterPaths;

    Status() {
        this.lineFormat = CLIText.get().lineFormat;
        this.statusFileListFormat = CLIText.get().statusFileListFormat;
        this.statusFileListFormatWithPrefix = CLIText.get().statusFileListFormatWithPrefix;
        this.statusFileListFormatUnmerged = CLIText.get().statusFileListFormatUnmerged;
    }

    @Override
    protected void run() throws Exception {
        int nbUntracked;
        int nbUnmerged;
        Ref head = this.db.getRef("HEAD");
        boolean firstHeader = true;
        if (head != null && head.isSymbolic()) {
            String branch = Repository.shortenRefName(head.getLeaf().getName());
            this.outw.println(CLIText.formatLine(MessageFormat.format(CLIText.get().onBranch, branch)));
        } else {
            this.outw.println(CLIText.formatLine(CLIText.get().notOnAnyBranch));
        }
        StatusCommand statusCommand = new Git(this.db).status();
        if (this.filterPaths != null && this.filterPaths.size() > 0) {
            for (String path : this.filterPaths) {
                statusCommand.addPath(path);
            }
        }
        org.eclipse.jgit.api.Status status = statusCommand.call();
        Set<String> added = status.getAdded();
        Set<String> changed = status.getChanged();
        Set<String> removed = status.getRemoved();
        Set<String> modified = status.getModified();
        Set<String> missing = status.getMissing();
        Set<String> untracked = status.getUntracked();
        Map<String, IndexDiff.StageState> unmergedStates = status.getConflictingStageState();
        ArrayList<String> toBeCommitted = new ArrayList<String>(added);
        toBeCommitted.addAll(changed);
        toBeCommitted.addAll(removed);
        int nbToBeCommitted = toBeCommitted.size();
        if (nbToBeCommitted > 0) {
            this.printSectionHeader(CLIText.get().changesToBeCommitted, new Object[0]);
            this.printList(CLIText.get().statusNewFile, CLIText.get().statusModified, CLIText.get().statusRemoved, toBeCommitted, added, changed, removed);
            firstHeader = false;
        }
        ArrayList<String> notStagedForCommit = new ArrayList<String>(modified);
        notStagedForCommit.addAll(missing);
        int nbNotStagedForCommit = notStagedForCommit.size();
        if (nbNotStagedForCommit > 0) {
            if (!firstHeader) {
                this.printSectionHeader("", new Object[0]);
            }
            this.printSectionHeader(CLIText.get().changesNotStagedForCommit, new Object[0]);
            this.printList(CLIText.get().statusModified, CLIText.get().statusRemoved, null, notStagedForCommit, modified, missing, null);
            firstHeader = false;
        }
        if ((nbUnmerged = unmergedStates.size()) > 0) {
            if (!firstHeader) {
                this.printSectionHeader("", new Object[0]);
            }
            this.printSectionHeader(CLIText.get().unmergedPaths, new Object[0]);
            this.printUnmerged(unmergedStates);
            firstHeader = false;
        }
        if ((nbUntracked = untracked.size()) > 0) {
            if (!firstHeader) {
                this.printSectionHeader("", new Object[0]);
            }
            this.printSectionHeader(CLIText.get().untrackedFiles, new Object[0]);
            this.printList(untracked);
        }
    }

    protected void printSectionHeader(String pattern, Object ... arguments) throws IOException {
        this.outw.println(CLIText.formatLine(MessageFormat.format(pattern, arguments)));
        if (!pattern.equals("")) {
            this.outw.println(CLIText.formatLine(""));
        }
        this.outw.flush();
    }

    protected int printList(Collection<String> list) throws IOException {
        if (!list.isEmpty()) {
            ArrayList<String> sortedList = new ArrayList<String>(list);
            Collections.sort(sortedList);
            for (String filename : sortedList) {
                this.outw.println(CLIText.formatLine(String.format(this.statusFileListFormat, filename)));
            }
            this.outw.flush();
            return list.size();
        }
        return 0;
    }

    protected int printList(String status1, String status2, String status3, Collection<String> list, Collection<String> set1, Collection<String> set2, Collection<String> set3) throws IOException {
        ArrayList<String> sortedList = new ArrayList<String>(list);
        Collections.sort(sortedList);
        for (String filename : sortedList) {
            String prefix = set1.contains(filename) ? status1 : (set2.contains(filename) ? status2 : status3);
            this.outw.println(CLIText.formatLine(String.format(this.statusFileListFormatWithPrefix, prefix, filename)));
            this.outw.flush();
        }
        return list.size();
    }

    private void printUnmerged(Map<String, IndexDiff.StageState> unmergedStates) throws IOException {
        ArrayList<String> paths = new ArrayList<String>(unmergedStates.keySet());
        Collections.sort(paths);
        for (String path : paths) {
            IndexDiff.StageState state = unmergedStates.get(path);
            String stateDescription = Status.getStageStateDescription(state);
            this.outw.println(CLIText.formatLine(String.format(this.statusFileListFormatUnmerged, stateDescription, path)));
            this.outw.flush();
        }
    }

    private static String getStageStateDescription(IndexDiff.StageState stageState) {
        CLIText text = CLIText.get();
        switch (stageState) {
            case BOTH_DELETED: {
                return text.statusBothDeleted;
            }
            case ADDED_BY_US: {
                return text.statusAddedByUs;
            }
            case DELETED_BY_THEM: {
                return text.statusDeletedByThem;
            }
            case ADDED_BY_THEM: {
                return text.statusAddedByThem;
            }
            case DELETED_BY_US: {
                return text.statusDeletedByUs;
            }
            case BOTH_ADDED: {
                return text.statusBothAdded;
            }
            case BOTH_MODIFIED: {
                return text.statusBothModified;
            }
        }
        throw new IllegalArgumentException("Unknown StageState: " + (Object)((Object)stageState));
    }
}

