/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.lv.ui.helper;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.tizen.common.lv.model.LVStringVO;
import org.tizen.common.lv.ui.LVLocalizationTab;

public class LVStringLabelProvider
extends ColumnLabelProvider
implements ITableLabelProvider {
    private boolean isKeyMode = false;

    public LVStringLabelProvider() {
    }

    public LVStringLabelProvider(boolean isKeyMode) {
        this.isKeyMode = isKeyMode;
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        int index = cell.getColumnIndex();
        switch (index) {
            case 0: {
                cell.setImage(this.getColumnImage(element, index));
            }
        }
        cell.setText(this.getColumnText(element, index));
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = "";
        if (element instanceof LVStringVO) {
            LVStringVO svo = (LVStringVO)element;
            switch (columnIndex) {
                case 0: {
                    if (LVLocalizationTab.KEY_MODE || this.isKeyMode) {
                        text = svo.getLocale().getLanguageTag();
                        break;
                    }
                    text = svo.getId();
                    break;
                }
                case 1: {
                    text = svo.getValue();
                }
            }
        }
        return text;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image image = null;
        if (element instanceof LVStringVO) {
            LVStringVO svo = (LVStringVO)element;
            switch (columnIndex) {
                case 0: {
                    if (!LVLocalizationTab.KEY_MODE && !this.isKeyMode) break;
                    image = svo.getLocale().getFlag();
                }
            }
        }
        return image;
    }
}

