/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.autoemul.wizard;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.autoemul.DeviceEntryManager;
import org.tizen.common.autoemul.messages.AutoEmulMessages;
import org.tizen.common.autoemul.thread.MonitorEmulatorThread;
import org.tizen.common.autoemul.thread.MonitorLaunchThread;
import org.tizen.common.autoemul.thread.MonitorStatusForAutoEmul;
import org.tizen.common.autoemul.wizard.AutoEmulDialogPage;
import org.tizen.common.autoemul.wizard.AutoEmulGenWizardDialog;

public class AutoEmulWizard
extends Wizard
implements IPageChangedListener {
    private Shell shell;
    private final String GUIDE_DIALOG_NAME = "Device Selection";
    private AutoEmulDialogPage testGuideDialogPage = null;
    private IProject iproject;
    private final Logger logger = LoggerFactory.getLogger(AutoEmulWizard.class);

    public AutoEmulWizard(Shell shell, IProject iproject) {
        this.setWindowTitle(AutoEmulMessages.SELECT_EMULATOR_WIZARD_TITLE);
        this.setNeedsProgressMonitor(true);
        this.iproject = iproject;
        this.shell = shell;
    }

    public boolean performFinish() {
        IWizardContainer container = this.getContainer();
        try {
            container.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    String selectedDeviceName = AutoEmulGenWizardDialog.getSelectionDeviceName();
                    if (DeviceEntryManager.checkAvailableDevice(selectedDeviceName)) {
                        monitor.beginTask("Launch " + AutoEmulWizard.this.iproject.getName() + " project to " + AutoEmulGenWizardDialog.getSelectionDeviceName() + " ", 10000);
                        MonitorEmulatorThread emualtor = new MonitorEmulatorThread();
                        Thread tEmulator = new Thread((Runnable)emualtor, selectedDeviceName);
                        tEmulator.start();
                        MonitorLaunchThread launcher = new MonitorLaunchThread(monitor);
                        Thread tLauncher = new Thread((Runnable)launcher, "launch");
                        tLauncher.start();
                        try {
                            tLauncher.join();
                        }
                        catch (InterruptedException e2) {
                            e2.printStackTrace();
                        }
                        monitor.done();
                    } else {
                        MonitorStatusForAutoEmul.setAvailableEmulator(false);
                        AutoEmulWizard.this.logger.error("fail to launch apps");
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return true;
    }

    public void addPages() {
        this.testGuideDialogPage = new AutoEmulDialogPage("Device Selection", this.shell, this.iproject);
        this.addPage((IWizardPage)this.testGuideDialogPage);
        WizardDialog dialog = (WizardDialog)this.getContainer();
        dialog.addPageChangedListener((IPageChangedListener)this);
    }

    public void pageChanged(PageChangedEvent arg0) {
    }

    public boolean canFinish() {
        return DeviceEntryManager.getOldDeviceList() != null && DeviceEntryManager.getOldDeviceList().size() > 0;
    }
}

