/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.NoMessageException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.util.RawParseUtils;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(common=true, usage="usage_recordChangesToRepository")
class Commit
extends TextBuiltin {
    @Option(name="--author", metaVar="metaVar_author", usage="usage_CommitAuthor")
    private String author;
    @Option(name="--message", aliases={"-m"}, metaVar="metaVar_message", usage="usage_CommitMessage", required=true)
    private String message;
    @Option(name="--only", aliases={"-o"}, usage="usage_CommitOnly")
    private boolean only;
    @Option(name="--all", aliases={"-a"}, usage="usage_CommitAll")
    private boolean all;
    @Option(name="--amend", usage="usage_CommitAmend")
    private boolean amend;
    @Argument(metaVar="metaVar_commitPaths", usage="usage_CommitPaths")
    private List<String> paths = new ArrayList<String>();

    Commit() {
    }

    protected void run() throws NoHeadException, NoMessageException, ConcurrentRefUpdateException, JGitInternalException, Exception {
        String branchName;
        RevCommit commit;
        CommitCommand commitCmd = new Git(this.db).commit();
        if (this.author != null) {
            commitCmd.setAuthor(RawParseUtils.parsePersonIdent(this.author));
        }
        if (this.message != null) {
            commitCmd.setMessage(this.message);
        }
        if (this.only && this.paths.isEmpty()) {
            throw Commit.die(CLIText.get().pathsRequired);
        }
        if (this.only && this.all) {
            throw Commit.die(CLIText.get().onlyOneOfIncludeOnlyAllInteractiveCanBeUsed);
        }
        if (!this.paths.isEmpty()) {
            for (String p : this.paths) {
                commitCmd.setOnly(p);
            }
        }
        commitCmd.setAmend(this.amend);
        commitCmd.setAll(this.all);
        Ref head = this.db.getRef("HEAD");
        try {
            commit = commitCmd.call();
        }
        catch (JGitInternalException e) {
            throw Commit.die(e.getMessage());
        }
        if (!head.isSymbolic()) {
            branchName = CLIText.get().branchDetachedHEAD;
        } else {
            branchName = head.getTarget().getName();
            if (branchName.startsWith("refs/heads/")) {
                branchName = branchName.substring("refs/heads/".length());
            }
        }
        this.outw.println("[" + branchName + " " + commit.name() + "] " + commit.getShortMessage());
    }
}

