/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.lv.ui.dialog;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.lv.LVConstants;
import org.tizen.common.lv.manager.LVManager;
import org.tizen.common.lv.message.LVMessages;
import org.tizen.common.lv.model.LVLocaleVO;
import org.tizen.common.lv.model.LVResourceVO;
import org.tizen.common.lv.ui.dialog.LVAbstractDialog;
import org.tizen.common.lv.ui.dialog.LocationSelectDialog;
import org.tizen.common.lv.ui.helper.LVResourceEditingSupport;
import org.tizen.common.lv.ui.helper.LVResourceLabelProvider;
import org.tizen.common.lv.ui.helper.LVTableUtil;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.FileUtil;

public class LVLocalizeResourceDialog
extends LVAbstractDialog {
    private final Logger logger = LoggerFactory.getLogger(LVLocalizeResourceDialog.class);
    private IProject project = null;
    private List<LVLocaleVO> targetLocaleList;
    private Composite compoInput;
    private Label label;
    private Text text;
    private Button browse;
    private TableViewer viewer;
    private TableViewerColumn viewerLocaleCol;
    private TableViewerColumn viewerResCol;
    private TableColumn locCol;
    private TableColumn resCol;
    private LVResourceLabelProvider lvResourceLabelProvider;

    public LVLocalizeResourceDialog(Shell parentShell, IProject project) {
        super(parentShell, LVMessages.UI_ADD_LV_TITLE, LVMessages.UI_ADD_RES_DESC);
        this.project = project;
        this.targetLocaleList = LVManager.getManager(project).getTargetLocaleList();
        this.lvResourceLabelProvider = new LVResourceLabelProvider();
    }

    public LVLocalizeResourceDialog(Shell parentShell, String title, String desc) {
        super(parentShell, title, desc);
    }

    @Override
    protected void createInput(Composite composite) {
        this.compoInput = new Composite(composite, 0);
        this.compoInput.setLayoutData((Object)new GridData(768));
        this.compoInput.setLayout((Layout)new GridLayout(3, false));
        this.label = new Label(this.compoInput, 0);
        this.label.setText(LVMessages.LABEL_ADD_RESOURCE);
        this.text = new Text(this.compoInput, 2048);
        this.text.setLayoutData((Object)new GridData(768));
        this.text.setText("/");
        this.browse = new Button(this.compoInput, 0);
        this.browse.setText("Browse...");
        this.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LocationSelectDialog dialog = new LocationSelectDialog(LVLocalizeResourceDialog.this.browse.getShell(), LVLocalizeResourceDialog.this.project, LVLocalizeResourceDialog.this.text);
                dialog.open();
            }
        });
    }

    @Override
    protected void createTable(Composite composite) {
        this.viewer = new TableViewer(composite, 68354);
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.createStrColumns(this.viewer);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        ArrayList<LVResourceVO> rvoList = new ArrayList<LVResourceVO>();
        for (LVLocaleVO locale : this.targetLocaleList) {
            rvoList.add(new LVResourceVO(locale));
        }
        this.viewer.setLabelProvider((IBaseLabelProvider)this.lvResourceLabelProvider);
        this.viewer.setInput(rvoList);
    }

    private void createStrColumns(TableViewer viewer) {
        this.viewerLocaleCol = LVTableUtil.createColumn(viewer, 0, LVConstants.WIDTH_COLS_LOCALIZE[0]);
        this.locCol = this.viewerLocaleCol.getColumn();
        this.locCol.setText(LVConstants.COLS_ADD_RESOURCE[0]);
        this.viewerResCol = LVTableUtil.createColumn(viewer, 0, LVConstants.WIDTH_COLS_LOCALIZE[1], true);
        this.viewerResCol.setEditingSupport((EditingSupport)new LVResourceEditingSupport(viewer));
        this.resCol = this.viewerResCol.getColumn();
        this.resCol.setText(LVConstants.COLS_ADD_RESOURCE[1]);
    }

    protected void okPressed() {
        String destinationFormat = String.valueOf(this.project.getLocation().toOSString()) + "%s" + this.text.getText() + "/%s";
        List rvoList = (List)this.viewer.getInput();
        LVResourceVO defaultRVO = (LVResourceVO)rvoList.get(0);
        String resourcePath = defaultRVO.getResourcePath();
        String defaultResourceName = FileUtil.getFileNameFromPath((String)resourcePath);
        String destination = String.format(destinationFormat, "", defaultResourceName);
        try {
            FileUtil.copyTo((String)resourcePath, (String)destination);
        }
        catch (IOException e) {
            this.logger.debug(e.getMessage());
            DialogUtil.openErrorDialog((String)String.format(LVMessages.ERROR_RESOURCE_SET, defaultResourceName));
            return;
        }
        int i = 1;
        while (i < rvoList.size()) {
            LVResourceVO rvo = (LVResourceVO)rvoList.get(i);
            resourcePath = rvo.getResourcePath();
            destination = String.format(destinationFormat, String.valueOf(File.separator) + "locales" + File.separator + rvo.getLocale().getLanguageTag(), defaultResourceName);
            this.copyFile(resourcePath, destination);
            ++i;
        }
        try {
            this.project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            this.logger.debug(e.getMessage());
        }
        super.okPressed();
    }

    private void copyFile(String from, String to) {
        if (from == null || from.equals("")) {
            this.logger.info("resource is empty");
            return;
        }
        try {
            FileUtil.copyTo((String)from, (String)to);
        }
        catch (IOException e) {
            this.logger.debug(e.getMessage());
        }
    }
}

