/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.ui.wizards;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.bind.JAXBException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.swt.widgets.Display;
import org.tizen.common.rest.RestPlugin;
import org.tizen.common.rest.model.RepositoryManager;
import org.tizen.common.rest.model.schema.Application;
import org.tizen.common.rest.ui.views.RestViewer;
import org.tizen.common.rest.ui.wizards.AbstractOperation;
import org.tizen.common.rest.util.OutputUtil;

public class WadlImportOperation
extends AbstractOperation {
    private RestViewer viewer;

    public WadlImportOperation(RestViewer viewer, String fileName) {
        super(fileName);
        this.viewer = viewer;
    }

    @Override
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (this.getFileName() != null) {
            Display display;
            RepositoryManager rManager;
            boolean add;
            String title;
            Application app;
            block9: {
                app = null;
                title = null;
                try {
                    File file = new File(this.getFileName());
                    if (file != null && file.exists()) {
                        title = file.getName().split("\\.")[0];
                        app = OutputUtil.loadWadl(file);
                        break block9;
                    }
                    try {
                        URL url = new URL(this.getFileName());
                        InputStream is = url.openStream();
                        app = OutputUtil.loadWadl(is);
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (MalformedURLException e) {
                        RestPlugin.log(e);
                    }
                    catch (IOException e) {
                        RestPlugin.log(e);
                    }
                }
                catch (JAXBException e) {
                    RestPlugin.log(e);
                }
            }
            if (this.viewer != null && app != null && (add = (rManager = RepositoryManager.getInstance()).updateOrAddApplication(app, title)) && (display = DebugUIPlugin.getStandardDisplay()) != null && !display.isDisposed()) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        WadlImportOperation.this.viewer.reloadTreeViewer();
                    }
                });
            }
        }
    }
}

