/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.ui.dialog;

import java.util.List;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.TableItem;
import org.tizen.common.sign.preferences.SigningProfile;
import org.tizen.common.sign.ui.dialog.Messages;
import org.tizen.common.sign.util.SigningProfileUtil;
import org.tizen.common.util.DialogUtil;

public class ProfileRemovalListener
extends MouseAdapter {
    private TableViewer profileTableViewer;

    public ProfileRemovalListener(TableViewer tableViewer) {
        this.profileTableViewer = tableViewer;
    }

    public void mouseUp(MouseEvent e) {
        boolean isTheLastProfile;
        TableItem[] items = this.profileTableViewer.getTable().getItems();
        if (items.length == 0) {
            return;
        }
        TableItem[] selectedItems = this.profileTableViewer.getTable().getSelection();
        if (selectedItems.length < 1) {
            return;
        }
        TableItem removableItem = selectedItems[0];
        int removableItemIndex = this.profileTableViewer.getTable().getSelectionIndex();
        SigningProfile selectedProfile = (SigningProfile)removableItem.getData();
        String activeProfileName = SigningProfileUtil.getActiveProfileName();
        boolean isActive = activeProfileName.equals(selectedProfile.getProfileName());
        TableItem nextActiveItem = null;
        int result = DialogUtil.openQuestionDialog((String)String.format(Messages.PROFILE_REMOVE_QUESTION, removableItem.getText()));
        if (result == 128) {
            return;
        }
        boolean bl = isTheLastProfile = items.length == 1;
        if (isActive && !isTheLastProfile) {
            nextActiveItem = items.length == removableItemIndex + 1 ? items[0] : this.profileTableViewer.getTable().getItem(removableItemIndex + 1);
            SigningProfile profile = (SigningProfile)nextActiveItem.getData();
            SigningProfileUtil.setActiveProfileName((String)profile.getProfileName());
        } else if (isActive & isTheLastProfile) {
            SigningProfileUtil.setActiveProfileName(null);
        } else {
            TableItem[] tableItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (item.getText().equals(activeProfileName)) {
                    nextActiveItem = item;
                    break;
                }
                ++n2;
            }
        }
        List input = (List)this.profileTableViewer.getInput();
        input.remove(removableItemIndex);
        SigningProfileUtil.getProfileContainerFromFile().removeProfile(selectedProfile);
        if (nextActiveItem != null) {
            this.profileTableViewer.getTable().setSelection(nextActiveItem);
            this.profileTableViewer.setSelection(this.profileTableViewer.getSelection(), true);
        }
        this.profileTableViewer.refresh();
        super.mouseUp(e);
    }
}

