/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.explorer;

import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TableItem;
import org.tizen.common.connection.explorer.RemoteDeviceManagerDeviceItem;
import org.tizen.common.connection.explorer.RemoteDeviceManagerDialog;

public class RemoteDeviceManagerTableLabelProvider
extends OwnerDrawLabelProvider {
    private RemoteDeviceManagerDialog dlg = null;

    public RemoteDeviceManagerTableLabelProvider(RemoteDeviceManagerDialog dlg) {
        this.dlg = dlg;
    }

    protected void erase(Event event, Object element) {
        if (event.index != 0) {
            event.gc.setBackground(this.dlg.tableLineColor);
            event.gc.fillRectangle(event.x, event.y, 1, event.height);
        }
        TableItem item = (TableItem)event.item;
        Color oldBackground = event.gc.getBackground();
        event.gc.setBackground(this.dlg.activeBgColor);
        if (item != null && item.getData("isSelect") != null && ((Boolean)item.getData("isSelect")).booleanValue()) {
            event.gc.setBackground(this.dlg.selectBgColor);
        }
        event.gc.fillRectangle(event.x + 1, event.y, event.width, event.height);
        event.gc.setBackground(oldBackground);
        super.erase(event, element);
    }

    protected void measure(Event event, Object element) {
        event.height = 25;
    }

    protected void paint(Event event, Object element) {
        RemoteDeviceManagerDeviceItem selectItem = (RemoteDeviceManagerDeviceItem)element;
        switch (event.index) {
            case 0: {
                event.gc.drawText(selectItem.getName(), event.x + 20, event.y + 4, true);
                break;
            }
            case 1: {
                Point e = event.gc.textExtent(selectItem.getIP(), 8);
                int startX = (118 - e.x) / 2;
                event.gc.drawText(selectItem.getIP(), event.x + startX, event.y + 4, true);
                break;
            }
            case 2: {
                event.gc.drawText(selectItem.getPort(), event.x + 20, event.y + 4, true);
                break;
            }
            case 3: {
                Image connectImg = this.dlg.connectedToggleOffImages;
                if (selectItem.isConnect()) {
                    connectImg = this.dlg.connectedToggleOnImages;
                }
                if (selectItem.isRunning()) {
                    event.gc.setAlpha(50);
                } else {
                    event.gc.setAlpha(255);
                }
                int imgStartX = event.x + 20;
                int imgStartY = event.y + 4;
                event.gc.drawImage(connectImg, imgStartX, imgStartY);
                if (!selectItem.isHover()) break;
                event.gc.setAlpha(100);
                event.gc.setBackground(this.dlg.tableLineColor);
                event.gc.fillRectangle(imgStartX, imgStartY, connectImg.getBounds().width, connectImg.getBounds().height);
            }
        }
    }
}

