/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.ui.validator;

import org.tizen.common.sign.preferences.SigningProfileContainer;
import org.tizen.common.sign.ui.validator.CertificateValidateMessage;
import org.tizen.common.sign.ui.validator.ICertificateValidator;
import org.tizen.common.sign.ui.validator.Messages;
import org.tizen.common.sign.util.SigningProfileUtil;

public class CertificateProfileValidator
implements ICertificateValidator {
    private final String REGEX_ALPHANUMERIC_WITH_UNDERSCORE_HYPHEN = "[a-zA-Z0-9_-]*";
    private SigningProfileContainer container = SigningProfileUtil.getProfileContainerFromFile();

    @Override
    public CertificateValidateMessage validate(String value) {
        if (value.isEmpty()) {
            return new CertificateValidateMessage(false, "");
        }
        if (!value.matches("[a-zA-Z0-9_-]*")) {
            return new CertificateValidateMessage(false, Messages.CERT_NAME_LIMITATION);
        }
        if (this.container.containsProfile(value.trim())) {
            return new CertificateValidateMessage(false, Messages.DUPLICATE_CERT_PROFILE_NAME);
        }
        return new CertificateValidateMessage();
    }
}

