/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.logview.resources;

import java.io.IOException;
import java.io.InputStream;
import javafx.application.Platform;
import javafx.scene.image.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.connection.logview.resources.ImageKind;
import org.tizen.common.connection.logview.resources.ResourceLoader;
import org.tizen.common.connection.logview.resources.ResourceRegistry;

final class ImageRegistry
extends ResourceRegistry<ImageKind, Image> {
    private final Platform platform;
    private Logger logger = LoggerFactory.getLogger(ImageRegistry.class);

    ImageRegistry(Platform platform) {
        this.platform = platform;
    }

    @Override
    Image getInternal(ImageKind kind) {
        Image i = null;
        InputStream is = ResourceLoader.load(String.valueOf(kind.name) + "." + (Object)((Object)kind.type), this.platform);
        if (is != null) {
            i = new Image(is);
            try {
                is.close();
            }
            catch (IOException e) {
                this.logger.info(e.getMessage());
            }
        }
        return i;
    }

    @Override
    void dispose() {
    }
}

