/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.checkBoxGroup;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class CheckBoxGroup
extends Composite {
    private Image oldImage;
    protected final Button button;
    private final Composite content;
    private final List<SelectionListener> selectionListeners;

    public CheckBoxGroup(Composite parent, int style) {
        super(parent, style);
        super.setLayout((Layout)new GridLayout());
        this.selectionListeners = new ArrayList<SelectionListener>();
        this.button = new Button((Composite)this, 32);
        GridData gdButton = new GridData(1, 2, true, false);
        gdButton.horizontalIndent = 15;
        this.button.setLayoutData((Object)gdButton);
        this.button.setSelection(true);
        this.button.setBackground(this.getBackground());
        this.button.pack();
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                e.doit = CheckBoxGroup.this.fireSelectionListeners(e);
                if (!e.doit) {
                    return;
                }
                if (CheckBoxGroup.this.button.getSelection()) {
                    CheckBoxGroup.this.activate();
                } else {
                    CheckBoxGroup.this.deactivate();
                }
            }
        });
        this.content = new Composite((Composite)this, 0);
        this.content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                CheckBoxGroup.this.drawWidget();
            }
        });
    }

    private boolean fireSelectionListeners(SelectionEvent selectionEvent) {
        selectionEvent.widget = this;
        for (SelectionListener listener : this.selectionListeners) {
            listener.widgetSelected(selectionEvent);
            if (selectionEvent.doit) continue;
            return false;
        }
        return true;
    }

    private void drawWidget() {
        Display display = this.getDisplay();
        Rectangle rect = this.getClientArea();
        Image newImage = new Image((Device)display, Math.max(1, rect.width), Math.max(1, rect.height));
        GC gc = new GC((Drawable)newImage);
        gc.setBackground(this.getBackground());
        gc.fillRectangle(0, 0, rect.width, rect.height);
        int margin = (int)((double)this.button.getSize().y * 1.5);
        int startY = margin / 2;
        gc.setForeground(this.getDisplay().getSystemColor(18));
        gc.drawRoundRectangle(1, startY, rect.width - 2, rect.height - startY - 2, 2, 2);
        gc.setForeground(this.getDisplay().getSystemColor(19));
        gc.drawRoundRectangle(2, startY + 1, rect.width - 4, rect.height - startY - 4, 2, 2);
        gc.dispose();
        this.setBackgroundImage(newImage);
        if (this.oldImage != null) {
            this.oldImage.dispose();
        }
        this.oldImage = newImage;
    }

    public void activate() {
        this.button.setSelection(true);
        SWTGraphicUtil.enable((Control)this.content, true);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        this.selectionListeners.add(listener);
    }

    public void deactivate() {
        this.button.setSelection(false);
        SWTGraphicUtil.enable((Control)this.content, false);
    }

    public boolean isActivated() {
        return this.button.getSelection();
    }

    public Layout getLayout() {
        return this.content.getLayout();
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        this.selectionListeners.remove(listener);
    }

    public boolean setFocus() {
        return this.content.setFocus();
    }

    public void setLayout(Layout layout) {
        this.content.setLayout(layout);
    }

    public String getText() {
        return this.button.getText();
    }

    public void setText(String text) {
        this.button.setText(text);
    }

    public Font getFont() {
        return this.button.getFont();
    }

    public void setFont(Font font) {
        this.button.setFont(font);
    }

    public Composite getContent() {
        return this.content;
    }
}

