/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.itemSelector;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.mihalis.opal.itemSelector.DLItem;
import org.mihalis.opal.utils.SWTGraphicUtil;
import org.mihalis.opal.utils.SimpleSelectionAdapter;

public class DualList
extends Composite {
    private final List<DLItem> items = new ArrayList<DLItem>();
    private final List<DLItem> selection = new ArrayList<DLItem>();
    private final Table itemsTable;
    private final Table selectionTable;
    private List<SelectionListener> eventTable;

    public DualList(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(4, false));
        this.itemsTable = this.createTable();
        this.itemsTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                DualList.this.selectItem();
            }
        });
        Button buttonSelectAll = this.createButton("double_right.png", true, 3);
        buttonSelectAll.addSelectionListener((SelectionListener)new SimpleSelectionAdapter(){

            @Override
            public void handle(SelectionEvent e) {
                DualList.this.selectAll();
            }
        });
        this.selectionTable = this.createTable();
        this.selectionTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                DualList.this.deselectItem();
            }
        });
        Button buttonMoveFirst = this.createButton("double_up.png", true, 3);
        buttonMoveFirst.addSelectionListener((SelectionListener)new SimpleSelectionAdapter(){

            @Override
            public void handle(SelectionEvent e) {
                DualList.this.moveSelectionToFirstPosition();
            }
        });
        Button buttonSelect = this.createButton("arrow_right.png", false, 2);
        buttonSelect.addSelectionListener((SelectionListener)new SimpleSelectionAdapter(){

            @Override
            public void handle(SelectionEvent e) {
                DualList.this.selectItem();
            }
        });
        Button buttonMoveUp = this.createButton("arrow_up.png", false, 2);
        buttonMoveUp.addSelectionListener((SelectionListener)new SimpleSelectionAdapter(){

            @Override
            public void handle(SelectionEvent e) {
                DualList.this.moveUpItem();
            }
        });
        Button buttonDeselect = this.createButton("arrow_left.png", false, 2);
        buttonDeselect.addSelectionListener((SelectionListener)new SimpleSelectionAdapter(){

            @Override
            public void handle(SelectionEvent e) {
                DualList.this.deselectItem();
            }
        });
        Button buttonMoveDown = this.createButton("arrow_down.png", false, 2);
        buttonMoveDown.addSelectionListener((SelectionListener)new SimpleSelectionAdapter(){

            @Override
            public void handle(SelectionEvent e) {
                DualList.this.moveDownItem();
            }
        });
        Button buttonDeselectAll = this.createButton("double_left.png", false, 1);
        buttonDeselectAll.addSelectionListener((SelectionListener)new SimpleSelectionAdapter(){

            @Override
            public void handle(SelectionEvent e) {
                DualList.this.deselectAll();
            }
        });
        Button buttonMoveLast = this.createButton("double_down.png", true, 1);
        buttonMoveLast.addSelectionListener((SelectionListener)new SimpleSelectionAdapter(){

            @Override
            public void handle(SelectionEvent e) {
                DualList.this.moveSelectionToLastPosition();
            }
        });
    }

    private Table createTable() {
        Table table = new Table((Composite)this, 66306);
        table.setLinesVisible(false);
        table.setHeaderVisible(false);
        GridData gd = new GridData(4, 4, true, true, 1, 4);
        gd.widthHint = 200;
        table.setLayoutData((Object)gd);
        new TableColumn(table, 0x1000000);
        new TableColumn(table, 16384);
        table.setData((Object)-1);
        return table;
    }

    private Button createButton(String fileName, boolean verticalExpand, int alignment) {
        Button button;
        block7: {
            Button button2 = new Button((Composite)this, 8);
            InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("images/" + fileName);
            try {
                final Image image = new Image((Device)this.getDisplay(), in);
                button2.setImage(image);
                button2.setLayoutData((Object)new GridData(2, alignment, false, verticalExpand));
                button2.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        SWTGraphicUtil.dispose((Resource)image);
                    }
                });
                button = button2;
                if (in == null) break block7;
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return button;
    }

    public void add(DLItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error((int)4);
        }
        this.items.add(item);
    }

    public void add(DLItem item, int index) {
        this.checkWidget();
        if (item == null) {
            SWT.error((int)4);
        }
        if (index <= 0 || index >= this.items.size()) {
            SWT.error((int)5);
        }
        this.items.add(index, item);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        if (this.eventTable == null) {
            this.eventTable = new ArrayList<SelectionListener>();
        }
        this.eventTable.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.remove(listener);
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index <= 0 || index >= this.items.size()) {
            return;
        }
        this.fireEvents(this.selection.remove(index));
        this.redrawTables();
    }

    public void deselect(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            SWT.error((int)4);
        }
        ArrayList<DLItem> toBeRemoved = new ArrayList<DLItem>();
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            if (index > 0 && index < this.items.size()) {
                toBeRemoved.add(this.selection.get(index));
            }
            ++n2;
        }
        for (DLItem item : toBeRemoved) {
            this.selection.remove(item);
        }
        toBeRemoved.clear();
        this.redrawTables();
    }

    public void deselect(int start, int end) {
        this.checkWidget();
        if (start > end) {
            SWT.error((int)6);
        }
        ArrayList<DLItem> toBeRemoved = new ArrayList<DLItem>();
        int index = start;
        while (index <= end) {
            if (index > 0 && index < this.items.size()) {
                toBeRemoved.add(this.selection.get(index));
            }
            ++index;
        }
        for (DLItem item : toBeRemoved) {
            this.selection.remove(item);
        }
        toBeRemoved.clear();
        this.redrawTables();
    }

    public void deselectAll() {
        this.checkWidget();
        this.items.addAll(this.selection);
        this.selection.clear();
        this.redrawTables();
    }

    public DLItem getItem(int index) {
        this.checkWidget();
        if (index <= 0 || index >= this.items.size()) {
            SWT.error((int)5);
        }
        return this.items.get(index);
    }

    public int getItemCount() {
        this.checkWidget();
        return this.items.size();
    }

    public DLItem[] getItems() {
        this.checkWidget();
        return this.items.toArray(new DLItem[this.items.size()]);
    }

    public List<DLItem> getItemsAsList() {
        this.checkWidget();
        return new ArrayList<DLItem>(this.items);
    }

    public DLItem[] getSelection() {
        this.checkWidget();
        return this.selection.toArray(new DLItem[this.items.size()]);
    }

    public List<DLItem> getSelectionAsList() {
        this.checkWidget();
        return new ArrayList<DLItem>(this.selection);
    }

    public int getSelectionCount() {
        this.checkWidget();
        return this.selection.size();
    }

    public void remove(int index) {
        this.checkWidget();
        if (index <= 0 || index >= this.items.size()) {
            SWT.error((int)5);
        }
        this.items.remove(index);
        this.redrawTables();
    }

    public void remove(int[] indices) {
        this.checkWidget();
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            if (index <= 0 || index >= this.items.size()) {
                SWT.error((int)5);
            }
            this.items.remove(index);
            ++n2;
        }
        this.redrawTables();
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            SWT.error((int)5);
        }
        int index = start;
        while (index <= end) {
            if (index <= 0 || index >= this.items.size()) {
                SWT.error((int)5);
            }
            this.items.remove(index);
            ++index;
        }
        this.redrawTables();
    }

    public void remove(DLItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error((int)4);
        }
        if (!this.items.contains(item)) {
            SWT.error((int)5);
        }
        this.items.remove(item);
        this.redrawTables();
    }

    public void removeAll() {
        this.checkWidget();
        this.items.clear();
        this.redrawTables();
    }

    public void select(int index) {
        this.checkWidget();
        if (index <= 0 || index >= this.items.size()) {
            return;
        }
        this.selection.add(this.items.get(index));
        this.fireEvents(this.items.get(index));
        this.redrawTables();
    }

    public void select(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            SWT.error((int)4);
        }
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            if (index > 0 && index < this.items.size()) {
                this.selection.add(this.items.get(index));
                this.fireEvents(this.items.get(index));
            }
            ++n2;
        }
        this.redrawTables();
    }

    public void select(int start, int end) {
        this.checkWidget();
        if (start > end) {
            SWT.error((int)6);
        }
        int index = start;
        while (index <= end) {
            if (index > 0 && index < this.items.size()) {
                this.selection.add(this.items.get(index));
                this.fireEvents(this.items.get(index));
            }
            ++index;
        }
        this.redrawTables();
    }

    public void selectAll() {
        this.checkWidget();
        this.selection.addAll(this.items);
        for (DLItem item : this.items) {
            this.fireEvents(item);
        }
        this.items.clear();
        this.redrawTables();
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        boolean itemsContainImage = this.itemsContainImage();
        Point itemsTableDefaultSize = this.itemsTable.computeSize(-1, -1);
        Point selectionTableDefaultSize = this.selectionTable.computeSize(-1, -1);
        int itemsTableSize = this.itemsTable.getSize().x;
        if (itemsTableDefaultSize.y > this.itemsTable.getSize().y) {
            itemsTableSize -= this.itemsTable.getVerticalBar().getSize().x;
        }
        int selectionTableSize = this.selectionTable.getSize().x;
        if (selectionTableDefaultSize.y > this.selectionTable.getSize().y) {
            selectionTableSize -= this.selectionTable.getVerticalBar().getSize().x;
        }
        if (itemsContainImage) {
            this.itemsTable.getColumn(0).pack();
            this.itemsTable.getColumn(1).setWidth(itemsTableSize - this.itemsTable.getColumn(0).getWidth());
            this.selectionTable.getColumn(0).pack();
            this.selectionTable.getColumn(1).setWidth(selectionTableSize - this.selectionTable.getColumn(0).getWidth());
        } else {
            this.itemsTable.getColumn(0).setWidth(itemsTableSize);
            this.selectionTable.getColumn(0).setWidth(selectionTableSize);
        }
    }

    private boolean itemsContainImage() {
        for (DLItem item : this.items) {
            if (item.getImage() == null) continue;
            return true;
        }
        for (DLItem item : this.selection) {
            if (item.getImage() == null) continue;
            return true;
        }
        return false;
    }

    public void setItem(int index, DLItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error((int)4);
        }
        if (index <= 0 || index >= this.items.size()) {
            SWT.error((int)6);
        }
        this.items.set(index, item);
        this.redrawTables();
    }

    public void setItems(DLItem[] items) {
        this.checkWidget();
        if (items == null) {
            SWT.error((int)4);
        }
        ArrayList<DLItem> temp = new ArrayList<DLItem>();
        DLItem[] dLItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            DLItem item = dLItemArray[n2];
            if (item == null) {
                SWT.error((int)5);
            }
            temp.add(item);
            ++n2;
        }
        this.items.clear();
        this.items.addAll(temp);
        this.redrawTables();
    }

    public void setItems(List<DLItem> items) {
        this.checkWidget();
        this.checkWidget();
        if (items == null) {
            SWT.error((int)4);
        }
        ArrayList<DLItem> temp = new ArrayList<DLItem>();
        for (DLItem item : items) {
            if (item == null) {
                SWT.error((int)5);
            }
            temp.add(item);
        }
        this.items.clear();
        this.items.addAll(temp);
        this.redrawTables();
    }

    private void redrawTables() {
        this.setRedraw(false);
        this.redrawTable(this.itemsTable, false);
        this.redrawTable(this.selectionTable, true);
        this.setRedraw(true);
        this.setBounds(this.getBounds());
    }

    private void redrawTable(Table table, boolean isSelected) {
        this.clean(table);
        this.fillData(table, isSelected ? this.selection : this.items);
    }

    private void clean(Table table) {
        if (table == null) {
            return;
        }
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            item.dispose();
            ++n2;
        }
    }

    private void fillData(Table table, List<DLItem> listOfData) {
        for (DLItem item : listOfData) {
            TableItem tableItem = new TableItem(table, 0);
            tableItem.setData((Object)item);
            if (item.getBackground() != null) {
                tableItem.setBackground(item.getBackground());
            }
            if (item.getForeground() != null) {
                tableItem.setForeground(item.getForeground());
            }
            if (item.getImage() != null) {
                tableItem.setImage(0, item.getImage());
            }
            if (item.getFont() != null) {
                tableItem.setFont(item.getFont());
            }
            tableItem.setText(1, item.getText());
        }
    }

    protected void moveSelectionToFirstPosition() {
        if (this.selectionTable.getSelectionCount() == 0) {
            return;
        }
        int index = 0;
        TableItem[] tableItemArray = this.selectionTable.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            DLItem item = (DLItem)tableItem.getData();
            this.selection.remove(item);
            this.selection.add(index++, item);
            ++n2;
        }
        this.redrawTables();
        this.selectionTable.select(0, index - 1);
        this.selectionTable.forceFocus();
    }

    protected void selectItem() {
        if (this.itemsTable.getSelectionCount() == 0) {
            return;
        }
        TableItem[] tableItemArray = this.itemsTable.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            DLItem item = (DLItem)tableItem.getData();
            this.selection.add(item);
            this.items.remove(item);
            ++n2;
        }
        this.redrawTables();
    }

    protected void moveUpItem() {
        if (this.selectionTable.getSelectionCount() == 0) {
            return;
        }
        int[] nArray = this.selectionTable.getSelectionIndices();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            if (index == 0) {
                this.selectionTable.forceFocus();
                return;
            }
            ++n2;
        }
        int[] newSelection = new int[this.selectionTable.getSelectionCount()];
        int newSelectionIndex = 0;
        TableItem[] tableItemArray = this.selectionTable.getSelection();
        int n3 = tableItemArray.length;
        int n4 = 0;
        while (n4 < n3) {
            TableItem tableItem = tableItemArray[n4];
            int position = this.selection.indexOf(tableItem.getData());
            this.swap(position, position - 1);
            newSelection[newSelectionIndex++] = position - 1;
            ++n4;
        }
        this.redrawTables();
        this.selectionTable.select(newSelection);
        this.selectionTable.forceFocus();
    }

    protected void deselectItem() {
        if (this.selectionTable.getSelectionCount() == 0) {
            return;
        }
        TableItem[] tableItemArray = this.selectionTable.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            DLItem item = (DLItem)tableItem.getData();
            this.items.add(item);
            this.selection.remove(item);
            ++n2;
        }
        this.redrawTables();
    }

    protected void moveDownItem() {
        if (this.selectionTable.getSelectionCount() == 0) {
            return;
        }
        int[] nArray = this.selectionTable.getSelectionIndices();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            if (index == this.selectionTable.getItemCount() - 1) {
                this.selectionTable.forceFocus();
                return;
            }
            ++n2;
        }
        int[] newSelection = new int[this.selectionTable.getSelectionCount()];
        int newSelectionIndex = 0;
        TableItem[] tableItemArray = this.selectionTable.getSelection();
        int n3 = tableItemArray.length;
        int n4 = 0;
        while (n4 < n3) {
            TableItem tableItem = tableItemArray[n4];
            int position = this.selection.indexOf(tableItem.getData());
            this.swap(position, position + 1);
            newSelection[newSelectionIndex++] = position + 1;
            ++n4;
        }
        this.redrawTables();
        this.selectionTable.select(newSelection);
        this.selectionTable.forceFocus();
    }

    private void swap(int first, int second) {
        DLItem temp = this.selection.get(first);
        this.selection.set(first, this.selection.get(second));
        this.selection.set(second, temp);
    }

    protected void moveSelectionToLastPosition() {
        if (this.selectionTable.getSelectionCount() == 0) {
            return;
        }
        int numberOfSelectedElements = this.selectionTable.getSelectionCount();
        TableItem[] tableItemArray = this.selectionTable.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            DLItem item = (DLItem)tableItem.getData();
            this.selection.remove(item);
            this.selection.add(item);
            ++n2;
        }
        this.redrawTables();
        int numberOfElements = this.selectionTable.getItemCount();
        this.selectionTable.select(numberOfElements - numberOfSelectedElements, numberOfElements - 1);
        this.selectionTable.forceFocus();
    }

    private void fireEvents(DLItem item) {
        if (this.eventTable == null) {
            return;
        }
        Event event = new Event();
        event.button = 1;
        event.display = this.getDisplay();
        event.item = null;
        event.widget = this;
        event.data = item;
        SelectionEvent selectionEvent = new SelectionEvent(event);
        for (SelectionListener listener : this.eventTable) {
            listener.widgetSelected(selectionEvent);
        }
    }
}

