/*
 * Decompiled with CFR 0.152.
 */
package zipeditor.actions;

import java.text.MessageFormat;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.actions.TextActionHandler;
import zipeditor.actions.ActionMessages;
import zipeditor.actions.ViewerAction;
import zipeditor.model.Node;

public class RenameNodeAction
extends ViewerAction {
    private TreeEditor fTreeEditor;
    private TableEditor fTableEditor;
    private Control fControl;
    private Text fTextEditor;
    private Composite fTextEditorParent;
    private TextActionHandler fTextActionHandler;
    private Node inlinedNode;
    private boolean saving = false;
    private String newName;
    private String[] modelProviderIds;

    public RenameNodeAction(StructuredViewer viewer) {
        super(ActionMessages.getString("RenameNodeAction.0"), viewer);
        this.setToolTipText(ActionMessages.getString("RenameNodeAction.1"));
        this.setId("org.tizen.common.externals.RenameAction");
        this.fControl = viewer.getControl();
        if (this.fControl instanceof Tree) {
            this.fTreeEditor = new TreeEditor((Tree)this.fControl);
        } else if (this.fControl instanceof Table) {
            this.fTableEditor = new TableEditor((Table)this.fControl);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private boolean checkOverwrite(final Shell shell, final Node destination) {
        final boolean[] result = new boolean[1];
        Runnable query = new Runnable(){

            @Override
            public void run() {
                String message = ActionMessages.getString("RenameNodeAction.2");
                String title = ActionMessages.getString("RenameNodeAction.3");
                result[0] = MessageDialog.openQuestion((Shell)shell, (String)title, (String)MessageFormat.format(message, destination.getName()));
            }
        };
        shell.getDisplay().syncExec(query);
        return result[0];
    }

    Composite createParent() {
        Composite result = new Composite((Composite)this.fControl, 0);
        if (this.fControl instanceof Tree) {
            TreeItem[] selectedItems = ((Tree)this.fControl).getSelection();
            this.fTreeEditor.horizontalAlignment = 16384;
            this.fTreeEditor.grabHorizontal = true;
            this.fTreeEditor.setEditor((Control)result, selectedItems[0]);
        } else {
            TableItem[] selectedItems = ((Table)this.fControl).getSelection();
            this.fTableEditor.horizontalAlignment = 16384;
            this.fTableEditor.grabHorizontal = true;
            this.fTableEditor.setEditor((Control)result, selectedItems[0], 0);
        }
        return result;
    }

    private void createTextEditor(final Node node) {
        this.fTextEditorParent = this.createParent();
        this.fTextEditorParent.setVisible(false);
        this.fTextEditorParent.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                Point textSize = RenameNodeAction.this.fTextEditor.getSize();
                Point parentSize = RenameNodeAction.this.fTextEditorParent.getSize();
                e.gc.drawRectangle(0, 0, Math.min(textSize.x + 4, parentSize.x - 1), parentSize.y - 1);
            }
        });
        this.fTextEditor = new Text(this.fTextEditorParent, 0);
        this.fTextEditor.setFont(this.fControl.getFont());
        this.fTextEditorParent.setBackground(this.fTextEditor.getBackground());
        this.fTextEditor.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                Point textSize = RenameNodeAction.this.fTextEditor.computeSize(-1, -1);
                textSize.x += textSize.y;
                Point parentSize = RenameNodeAction.this.fTextEditorParent.getSize();
                RenameNodeAction.this.fTextEditor.setBounds(2, 1, Math.min(textSize.x, parentSize.x - 4), parentSize.y - 2);
                RenameNodeAction.this.fTextEditorParent.redraw();
            }
        });
        this.fTextEditor.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 2: {
                        RenameNodeAction.this.disposeTextWidget();
                        event.doit = true;
                        event.detail = 0;
                        break;
                    }
                    case 4: {
                        RenameNodeAction.this.saveChangesAndDispose(node);
                        event.doit = true;
                        event.detail = 0;
                    }
                }
            }
        });
        this.fTextEditor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent fe) {
                RenameNodeAction.this.saveChangesAndDispose(node);
            }
        });
        if (this.fTextActionHandler != null) {
            this.fTextActionHandler.addText(this.fTextEditor);
        }
    }

    private void disposeTextWidget() {
        if (this.fTextActionHandler != null) {
            this.fTextActionHandler.removeText(this.fTextEditor);
        }
        if (this.fTextEditorParent != null) {
            this.fTextEditorParent.dispose();
            this.fTextEditorParent = null;
            this.fTextEditor = null;
            if (this.fTreeEditor != null) {
                this.fTreeEditor.setEditor(null, null);
            } else {
                this.fTableEditor.setEditor(null, null, 0);
            }
        }
    }

    private void queryNewNodeNameInline(Node node) {
        if (node == null) {
            return;
        }
        if (this.fTextEditorParent == null) {
            this.createTextEditor(node);
        }
        this.fTextEditor.setText(node.getName());
        this.fTextEditorParent.setVisible(true);
        Point textSize = this.fTextEditor.computeSize(-1, -1);
        textSize.x += textSize.y;
        Point parentSize = this.fTextEditorParent.getSize();
        int inset = 1;
        this.fTextEditor.setBounds(2, inset, Math.min(textSize.x, parentSize.x - 4), parentSize.y - 2 * inset);
        this.fTextEditorParent.redraw();
        this.fTextEditor.selectAll();
        this.fTextEditor.setFocus();
    }

    public void run() {
        Node[] nodes = this.getSelectedNodes();
        if (nodes.length == 1) {
            this.queryNewNodeNameInline(nodes[0]);
        }
    }

    private Node getSelectedNode() {
        Node[] nodes = this.getSelectedNodes();
        return nodes.length > 0 ? nodes[0] : null;
    }

    protected void runWithNewName(String name) {
        this.newName = name;
        this.doOperation();
    }

    private void saveChangesAndDispose(Node node) {
        if (this.saving) {
            return;
        }
        this.saving = true;
        this.inlinedNode = node;
        final String newName = this.fTextEditor.getText();
        Runnable query = new Runnable(){

            @Override
            public void run() {
                try {
                    if (!newName.equals(RenameNodeAction.this.inlinedNode.getName())) {
                        RenameNodeAction.this.runWithNewName(newName);
                    }
                    RenameNodeAction.this.inlinedNode = null;
                    RenameNodeAction.this.disposeTextWidget();
                    if (RenameNodeAction.this.fControl != null && !RenameNodeAction.this.fControl.isDisposed()) {
                        RenameNodeAction.this.fControl.setFocus();
                    }
                }
                finally {
                    RenameNodeAction.this.saving = false;
                }
            }
        };
        this.fControl.getDisplay().asyncExec(query);
    }

    public void setTextActionHandler(TextActionHandler actionHandler) {
        this.fTextActionHandler = actionHandler;
    }

    public String[] getModelProviderIds() {
        return this.modelProviderIds;
    }

    public void setModelProviderIds(String[] modelProviderIds) {
        this.modelProviderIds = modelProviderIds;
    }

    protected void doOperation() {
        Node node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        Node newNode = this.newName != null ? node.getParent().getChildByName(this.newName, false) : null;
        boolean go = true;
        if (newNode != null) {
            go = this.checkOverwrite(this.fControl.getShell(), newNode);
        }
        if (go) {
            node.setName(this.newName);
        }
    }
}

