/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.lv.ui.dialog;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.tizen.common.lv.message.LVMessages;
import org.tizen.common.lv.ui.resource.TizenWebLocaleUtil;

public class LocationSelectDialog
extends TitleAreaDialog {
    private IProject project;
    private Text text;
    private TreeViewer treeViewer;

    public LocationSelectDialog(Shell parentShell, IProject project, Text text) {
        super(parentShell);
        this.project = project;
        this.text = text;
        this.setShellStyle(65568);
        this.setBlockOnOpen(true);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(LVMessages.UI_RESOURCE_LOCATION_TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        super.createDialogArea(parent);
        this.setTitle(LVMessages.UI_SELECT_LOCATION);
        this.treeViewer = new TreeViewer(parent, 2052);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.treeViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.treeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer paramViewer, Object parentElement, Object element) {
                if (element instanceof IFolder) {
                    return TizenWebLocaleUtil.isLocalizableFolder(((IFolder)element).getName());
                }
                if (element instanceof IProject) {
                    return LocationSelectDialog.this.project.equals(element);
                }
                return false;
            }
        });
        this.treeViewer.setInput((Object)ResourcesPlugin.getWorkspace());
        this.treeViewer.expandAll();
        return parent;
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        IResource resource = (IResource)selection.getFirstElement();
        this.text.setText("/" + resource.getProjectRelativePath().toOSString());
        super.okPressed();
    }
}

