/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.lv.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.tizen.common.lv.LVConstants;
import org.tizen.common.lv.model.LVLocaleVO;
import org.tizen.common.lv.ui.helper.ILocaleChangeListener;
import org.tizen.common.lv.ui.helper.LVLocaleLabelProvider;
import org.tizen.common.lv.ui.helper.LVTableUtil;

public class LVLocaleViewer
extends CheckboxTableViewer {
    private CheckboxTableViewer checkboxTableViewer;
    private List<LVLocaleVO> checkedList = null;
    private List<ILocaleChangeListener> localeChangeListeners = null;
    private final int MIN_WIDTH = 300;
    private final int MIN_HEIGHT = 300;

    private LVLocaleViewer(CheckboxTableViewer viewer) {
        super(viewer.getTable());
        this.checkboxTableViewer = viewer;
        this.initializeTable();
    }

    private void initializeTable() {
        Table table = this.checkboxTableViewer.getTable();
        this.createColumns();
        this.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                LVLocaleViewer.this.setChecked(event.getElement(), event.getChecked());
            }
        });
        this.getTable().getColumn(0).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List input = (List)LVLocaleViewer.this.getInput();
                int listSize = input.size();
                int checkedSize = LVLocaleViewer.this.getCheckedElements().length;
                boolean checkAll = true;
                if (listSize == checkedSize) {
                    checkAll = false;
                }
                LVLocaleViewer.this.setAllChecked(checkAll);
                LVLocaleViewer.this.notifyCheckedElementsCnt();
            }
        });
        GridData layoutData = new GridData(4, 4, true, true, 1, 1);
        layoutData.minimumWidth = 300;
        layoutData.minimumHeight = 300;
        table.setLayoutData((Object)layoutData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    public static LVLocaleViewer createViewer(Composite parent, List<LVLocaleVO> input) {
        CheckboxTableViewer checkboxTableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)68352);
        LVLocaleViewer viewer = new LVLocaleViewer(checkboxTableViewer);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setInput(input);
        return viewer;
    }

    private void createColumns() {
        LVLocaleLabelProvider lvLocaleLabelProvider = new LVLocaleLabelProvider();
        TableViewerColumn viewerColCheck = LVTableUtil.createColumn((TableViewer)this.checkboxTableViewer, 0, LVConstants.COLS_LOCALE[0], LVConstants.WIDTH_COLS_LOCALE[0], false);
        viewerColCheck.setLabelProvider((CellLabelProvider)lvLocaleLabelProvider);
        TableViewerColumn viewerColLangTag = LVTableUtil.createColumn((TableViewer)this.checkboxTableViewer, 0, LVConstants.COLS_LOCALE[1], LVConstants.WIDTH_COLS_LOCALE[1], false);
        viewerColLangTag.setLabelProvider((CellLabelProvider)lvLocaleLabelProvider);
        TableViewerColumn viewerColLang = LVTableUtil.createColumn((TableViewer)this.checkboxTableViewer, 0, LVConstants.COLS_LOCALE[2], LVConstants.WIDTH_COLS_LOCALE[2], true);
        viewerColLang.setLabelProvider((CellLabelProvider)lvLocaleLabelProvider);
        TableViewerColumn viewerColRegion = LVTableUtil.createColumn((TableViewer)this.checkboxTableViewer, 0, LVConstants.COLS_LOCALE[3], LVConstants.WIDTH_COLS_LOCALE[3], true);
        viewerColRegion.setLabelProvider((CellLabelProvider)lvLocaleLabelProvider);
    }

    public LVLocaleVO[] getCheckedLocales() {
        Object[] objs = this.getCheckedElements();
        return (LVLocaleVO[])Arrays.copyOf(objs, objs.length, LVLocaleVO[].class);
    }

    public void notifyCheckedElementsCnt() {
        if (this.localeChangeListeners != null) {
            for (ILocaleChangeListener listener : this.localeChangeListeners) {
                listener.localeChanged(this.getCheckedElements());
            }
        }
    }

    public void onCheckStateChanged(Object obj, boolean setChecked) {
        if (this.checkedList != null) {
            LVLocaleVO locale = (LVLocaleVO)obj;
            if (setChecked) {
                this.addCheckedLocale(locale);
            } else {
                this.removeCheckedLocale(locale);
            }
        }
    }

    public void deleteCheckedList() {
        this.checkedList = null;
    }

    public List<LVLocaleVO> getCheckedList() {
        Object[] checkedElements = this.getCheckedElements();
        LVLocaleVO[] checkedLocales = (LVLocaleVO[])Arrays.copyOf(checkedElements, checkedElements.length, LVLocaleVO[].class);
        if (this.checkedList == null) {
            this.checkedList = new ArrayList<LVLocaleVO>();
        } else {
            this.checkedList.clear();
        }
        LVLocaleVO[] lVLocaleVOArray = checkedLocales;
        int n = checkedLocales.length;
        int n2 = 0;
        while (n2 < n) {
            LVLocaleVO locale = lVLocaleVOArray[n2];
            this.addCheckedLocale(locale);
            ++n2;
        }
        return this.checkedList;
    }

    private void addCheckedLocale(LVLocaleVO locale) {
        if (!this.checkedList.contains(locale)) {
            this.checkedList.add(locale);
        }
    }

    private void removeCheckedLocale(LVLocaleVO locale) {
        if (this.checkedList.contains(locale)) {
            this.checkedList.remove(locale);
        }
    }

    public Object[] getCheckedElements() {
        if (this.checkedList == null) {
            return super.getCheckedElements();
        }
        return this.checkedList.toArray();
    }

    public boolean setChecked(Object element, boolean state) {
        this.onCheckStateChanged(element, state);
        boolean setChecked = super.setChecked(element, state);
        this.notifyCheckedElementsCnt();
        return setChecked;
    }

    public void setSuperChecked(Object element, boolean state) {
        super.setChecked(element, state);
    }

    public void addLocaleChangeListener(ILocaleChangeListener listener) {
        if (this.localeChangeListeners == null) {
            this.localeChangeListeners = new ArrayList<ILocaleChangeListener>();
        }
        if (!this.localeChangeListeners.contains(listener)) {
            this.localeChangeListeners.add(listener);
        }
    }
}

