/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.ui.handlers;

import java.io.File;
import org.eclipse.core.resources.IStorage;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.tizen.common.rest.RestPlugin;
import org.tizen.common.rest.model.RepositoryManager;
import org.tizen.common.rest.model.schema.Application;
import org.tizen.common.rest.ui.handlers.RESTCommonHandler;
import org.tizen.common.rest.util.LFSInput;
import org.tizen.common.rest.util.LocalFileStorageRO;

public class RESTViewSourceHandler
extends RESTCommonHandler {
    private static final String TIZEN_READONLY_EDITOR_ID = "org.tizen.common.ui.editors.XMLSourceEditor";

    @Override
    public Object execute() {
        Object obj = this.selection.getFirstElement();
        if (obj instanceof Application) {
            Application app = (Application)obj;
            File file = RepositoryManager.getInstance().getFile(app);
            if (file != null && file.exists()) {
                IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = workbenchWindow.getActivePage();
                LocalFileStorageRO fileStore = new LocalFileStorageRO(file);
                LFSInput input = new LFSInput((IStorage)fileStore);
                IEditorRegistry editorReg = workbenchWindow.getWorkbench().getEditorRegistry();
                IEditorDescriptor editorDesc = editorReg.findEditor(TIZEN_READONLY_EDITOR_ID);
                if (editorDesc == null) {
                    editorDesc = editorReg.getDefaultEditor("*.xml");
                }
                if (editorDesc != null) {
                    String editorId = editorDesc.getId();
                    try {
                        page.openEditor((IEditorInput)input, editorId, true, 1);
                    }
                    catch (PartInitException e) {
                        RestPlugin.log(e);
                    }
                }
            }
        }
        return null;
    }
}

