/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.ui.preferences;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.tizen.common.rest.RestPlugin;

public abstract class AbstractPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public AbstractPreferencePage(String description) {
        this.setPreferenceStore(RestPlugin.getDefault().getPreferenceStore());
        this.setDescription(description);
    }

    protected Control createContents(Composite parent) {
        Composite composite = this.createContentArea(parent);
        this.loadData();
        return composite;
    }

    protected abstract Composite createContentArea(Composite var1);

    protected abstract void loadData();

    public void init(IWorkbench workbench) {
    }

    protected Composite createComposite(Composite parent, int numColumn) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(numColumn, false);
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true, 1, 1);
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected Label createLabel(Composite parent, String string) {
        Label l = new Label(parent, 128);
        l.setText(string);
        return l;
    }

    protected Button createButton(Composite parent, String string, int width, int height) {
        return this.createButton(parent, 8, string, width, height);
    }

    protected Button createButton(Composite parent, int style, String string, int width, int height) {
        Button b = new Button(parent, style);
        b.setText(string);
        if (width > 0 && height > 0) {
            b.setSize(width, height);
        }
        return b;
    }

    protected void createSeparator(Composite parent, int horizontalSpan) {
        Label separator = new Label(parent, 258);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = horizontalSpan;
        separator.setLayoutData((Object)gridData);
    }

    protected Text createText(Composite parent, int textStyle, String key, int widthHint, int horizontalSpan) {
        return this.createText(parent, textStyle, key, 768, widthHint, horizontalSpan);
    }

    protected Text createText(Composite parent, int textStyle, String key, int layoutStyle, int widthHint, int horizontalSpan) {
        Text text = new Text(parent, textStyle);
        GridData gd = new GridData(layoutStyle);
        if (widthHint != 0) {
            gd.widthHint = widthHint;
        }
        gd.horizontalSpan = horizontalSpan;
        text.setLayoutData((Object)gd);
        String str = this.getValue(key);
        text.setText(str);
        return text;
    }

    protected String getValue(String key) {
        return this.getPreferenceStore().getString(key);
    }

    protected void setValue(String key, String value) {
        this.getPreferenceStore().setValue(key, value);
    }

    protected String getDefault(String key) {
        return this.getPreferenceStore().getDefaultString(key);
    }

    protected void setDefault(String key, String value) {
        this.getPreferenceStore().setDefault(key, value);
    }

    protected void performApply() {
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }
}

