/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.model.run;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.tizen.common.rest.exception.ResourcesNotFoundException;
import org.tizen.common.rest.model.run.Cookie;
import org.tizen.common.rest.model.run.FileArgument;
import org.tizen.common.rest.model.schema.IWadlModel;
import org.tizen.common.rest.model.schema.Method;
import org.tizen.common.rest.model.schema.Param;
import org.tizen.common.rest.model.schema.ParamStyle;
import org.tizen.common.rest.model.schema.Representation;
import org.tizen.common.rest.model.schema.Request;
import org.tizen.common.rest.model.schema.Resource;
import org.tizen.common.rest.run.AbstractParamAuthProcessor;
import org.tizen.common.rest.util.ModelUtil;
import org.tizen.common.rest.util.StringUtil;

public class RequestModel
implements Serializable {
    private static final long serialVersionUID = -3566269813994305915L;
    private String method;
    private boolean useKeepAlive = true;
    private boolean useMultipart = false;
    private String encoding = "UTF-8";
    private Map<String, NameValuePair> paramMap = new LinkedHashMap<String, NameValuePair>();
    private Map<String, NameValuePair> pathVariableMap = new LinkedHashMap<String, NameValuePair>();
    private List<FileArgument> fileArgumentList = new ArrayList<FileArgument>();
    private Map<String, String> headerMap = new LinkedHashMap<String, String>();
    private Map<String, Cookie> cookieMap = new LinkedHashMap<String, Cookie>();
    private String requestUrl;
    private Method api;

    public RequestModel(Method api) throws ResourcesNotFoundException {
        this.api = api;
        this.initialize(api);
    }

    private void initialize(Method api) {
        this.requestUrl = StringUtil.getFullPathString(api);
        this.initializeParentParams(api);
        api = ModelUtil.findReferences(api);
        this.method = api.getName();
        Request req = api.getRequest();
        if (req != null) {
            this.initializeRequest(req);
        }
        this.pathVariableMap.putAll(this.paramMap);
        this.pathVariableMap.putAll(StringUtil.getActiveProfileVariablesMap());
        this.requestUrl = this.fillPathVariables(this.requestUrl, this.pathVariableMap);
    }

    private String fillPathVariables(String url, Map<String, NameValuePair> pathVariableMap) {
        if (pathVariableMap.size() > 0) {
            url = StringUtil.getConvertedPath(url, pathVariableMap);
        }
        return url;
    }

    private void initializeParentParams(IWadlModel model) {
        IWadlModel parent = model.getParent();
        if (parent instanceof Resource) {
            Resource res = (Resource)parent;
            List<Param> paramList = res.getParam();
            this.fillParameters(paramList, false);
            this.initializeParentParams(res);
        }
    }

    private void initializeRequest(Request req) {
        List<Representation> repList = req.getRepresentation();
        int i = 0;
        while (i < repList.size()) {
            Representation rep = repList.get(i);
            rep = ModelUtil.findReferences(rep);
            String mediaType = rep.getMediaType();
            List<Param> paramList = rep.getParam();
            if ("multipart/form-data".equals(mediaType)) {
                this.setUseMultipart(true);
                this.fillFileArgument(paramList);
            } else {
                this.fillParameters(paramList);
            }
            ++i;
        }
        List<Param> paramList = req.getParam();
        this.fillParameters(paramList);
    }

    private void fillFileArgument(List<Param> paramList) {
        int i = 0;
        while (i < paramList.size()) {
            Param param = paramList.get(i);
            param = ModelUtil.findReferences(param);
            ParamStyle style = param.getStyle();
            switch (style) {
                case QUERY: {
                    String name = param.getName();
                    name = StringUtil.getConvertedStringFromActiveProfile(name);
                    String filePath = param.getDefault();
                    filePath = StringUtil.getConvertedStringFromActiveProfile(filePath);
                    if (filePath != null && filePath.startsWith("file:")) {
                        filePath = RequestModel.stripFilePath(filePath);
                        FileArgument fa = FileArgument.createFileArgument(filePath, name, null);
                        this.fileArgumentList.add(fa);
                        break;
                    }
                    if (filePath == null || this.paramMap.containsKey(name)) break;
                    this.paramMap.put(name, (NameValuePair)new BasicNameValuePair(name, filePath));
                    break;
                }
                case HEADER: {
                    this.addHeader(param);
                    break;
                }
            }
            ++i;
        }
    }

    private static String stripFilePath(String filePath) {
        filePath = filePath.substring("file:".length(), filePath.length());
        return filePath;
    }

    private void fillParameters(List<Param> paramList) {
        this.fillParameters(paramList, true);
    }

    private void fillParameters(List<Param> paramList, boolean overwrite) {
        int i = 0;
        while (i < paramList.size()) {
            Param param = paramList.get(i);
            param = ModelUtil.findReferences(param);
            String name = param.getName();
            name = StringUtil.getConvertedStringFromActiveProfile(name);
            String value = param.getDefault();
            if (value != null) {
                value = StringUtil.getConvertedStringFromActiveProfile(value);
                ParamStyle style = param.getStyle();
                switch (style) {
                    case QUERY: {
                        if (!overwrite && this.paramMap.containsKey(name)) break;
                        this.paramMap.put(name, (NameValuePair)new BasicNameValuePair(name, value));
                        break;
                    }
                    case HEADER: {
                        this.addHeader(param, overwrite);
                        break;
                    }
                    case TEMPLATE: {
                        if (!overwrite && this.pathVariableMap.containsKey(name)) break;
                        this.pathVariableMap.put(name, (NameValuePair)new BasicNameValuePair(name, value));
                        break;
                    }
                }
            }
            ++i;
        }
    }

    private void addHeader(Param param) {
        this.addHeader(param, true);
    }

    private void addHeader(Param param, boolean overwrite) {
        String name = param.getName();
        name = StringUtil.getConvertedStringFromActiveProfile(name);
        String value = param.getDefault();
        value = StringUtil.getConvertedStringFromActiveProfile(value);
        if ("cookie".equalsIgnoreCase(name)) {
            if (overwrite || !this.cookieMap.containsKey(value)) {
                Cookie c = new Cookie();
                c.setCookieData(value);
                this.cookieMap.put(value, c);
            }
        } else if (overwrite || !this.headerMap.containsKey(name)) {
            this.headerMap.put(name, value);
        }
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public boolean isUseKeepAlive() {
        return this.useKeepAlive;
    }

    public void setUseKeepAlive(boolean useKeepAlive) {
        this.useKeepAlive = useKeepAlive;
    }

    public boolean isUseMultipart() {
        return this.useMultipart;
    }

    public void setUseMultipart(boolean useMultipart) {
        this.useMultipart = useMultipart;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public List<NameValuePair> getParamList() {
        return new ArrayList<NameValuePair>(this.paramMap.values());
    }

    public List<NameValuePair> getPathVariableList() {
        return new ArrayList<NameValuePair>(this.pathVariableMap.values());
    }

    public List<FileArgument> getFileArgumentList() {
        return this.fileArgumentList;
    }

    public void setFileArgumentList(List<FileArgument> fileArgumentList) {
        this.fileArgumentList = fileArgumentList;
    }

    public Map<String, String> getHeaderMap() {
        return this.headerMap;
    }

    public void setHeaderMap(Map<String, String> headerMap) {
        this.headerMap = headerMap;
    }

    public Map<String, Cookie> getCookieMap() {
        return this.cookieMap;
    }

    public void setCookieMap(Map<String, Cookie> cookieMap) {
        this.cookieMap = cookieMap;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public String toPrintableString() {
        String value;
        StringBuilder builder = new StringBuilder();
        String lf = StringUtil.getLineSeparator();
        builder.append("##### Request Infomation #####" + lf);
        builder.append("\tURL : " + this.getRequestUrl() + lf);
        builder.append("\tMethod : " + this.getMethod() + lf);
        builder.append("\tContent encoding : " + this.getEncoding() + lf);
        builder.append("\tUse KeepAlive : " + this.isUseKeepAlive() + lf);
        builder.append("\tUse multipart/form-data for POST : " + this.isUseMultipart() + lf);
        if (this.getParamList() != null && this.getParamList().size() > 0) {
            builder.append("\t### Parameter Schema ###" + lf);
            int i = 0;
            while (i < this.getParamList().size()) {
                NameValuePair arg = this.getParamList().get(i);
                String name = arg.getName();
                value = arg.getValue();
                builder.append("\t\tName=" + name + ", Value=" + value + lf);
                ++i;
            }
        }
        if (this.getCookieMap() != null && this.getCookieMap().size() > 0) {
            builder.append("\t### Cookie ###" + lf);
            for (Cookie cookie : this.getCookieMap().values()) {
                String cookieData = StringUtil.getCookieData(cookie);
                builder.append("\t\t" + cookieData + lf);
            }
        }
        if (this.getHeaderMap() != null && this.getHeaderMap().size() > 0) {
            builder.append("\t### Header ###" + lf);
            for (Map.Entry<String, String> entry : this.getHeaderMap().entrySet()) {
                String key = entry.getKey();
                value = entry.getValue();
                builder.append("\t\t" + key + " = " + value + lf);
            }
        }
        return builder.toString();
    }

    public Method getApi() {
        return this.api;
    }

    public void applyAuthProcessor(AbstractParamAuthProcessor authProcessor) {
        List<AbstractParamAuthProcessor.BasicNameValue> list = authProcessor.getParamList();
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                AbstractParamAuthProcessor.BasicNameValue nameValue = list.get(i);
                int type = nameValue.getType();
                NameValuePair pair = nameValue.getPair();
                if (1 == type) {
                    this.headerMap.put(pair.getName(), pair.getValue());
                } else if (2 == type) {
                    this.paramMap.put(pair.getName(), pair);
                }
                ++i;
            }
        }
    }
}

