/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.logview.parser;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tizen.common.connection.logview.model.Log;
import org.tizen.common.connection.logview.parser.IDlogParser;
import org.tizen.sdblib.util.LogLevel;

public class DlogTVParserNew
implements IDlogParser {
    public static final String DLOG_FORMAT_REGEX = "^(\\d\\d-\\d\\d\\s\\d\\d:\\d\\d:\\d\\d\\.\\d+\\+\\d+)\\s([VDIWEF])\\/(.+)\\(P\\s(\\d*),\\sT\\s(\\d+)\\):(.*)$";
    private Pattern pattern = Pattern.compile("^(\\d\\d-\\d\\d\\s\\d\\d:\\d\\d:\\d\\d\\.\\d+\\+\\d+)\\s([VDIWEF])\\/(.+)\\(P\\s(\\d*),\\sT\\s(\\d+)\\):(.*)$");
    private final String DLOG_COMMAND_FORMAT = "/usr/bin/dlogutil -v threadtime *:%s";

    @Override
    public Log parse(String line) {
        Matcher matcher = this.pattern.matcher(line);
        if (matcher.matches()) {
            LogLevel logLevel = LogLevel.getByLetter((String)matcher.group(2));
            String pid = matcher.group(3);
            String tid = matcher.group(4);
            String tag = matcher.group(5).trim();
            String time = matcher.group(1);
            String message = matcher.group(6).replaceAll("\t", "    ");
            return new Log(logLevel, pid, tid, tag, time, message);
        }
        return null;
    }

    @Override
    public ArrayList<Log> parse(String[] lines) {
        ArrayList<Log> logs = new ArrayList<Log>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            Matcher matcher = this.pattern.matcher(line);
            if (matcher.matches()) {
                LogLevel logLevel = LogLevel.getByLetter((String)matcher.group(2));
                String pid = matcher.group(3);
                String tid = matcher.group(4);
                String tag = matcher.group(5).trim();
                String time = matcher.group(1);
                String message = matcher.group(6).replaceAll("\t", "    ");
                logs.add(new Log(logLevel, pid, tid, tag, time, message));
            }
            ++n2;
        }
        return logs;
    }

    @Override
    public String getDlogUtilCommandFormat() {
        return "/usr/bin/dlogutil -v threadtime *:%s";
    }
}

