/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.ui.preferences;

import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.tizen.common.rest.model.RepositoryManager;
import org.tizen.common.rest.model.schema.Application;
import org.tizen.common.rest.model.schema.Resources;
import org.tizen.common.rest.ui.views.RestViewerContentProvider;
import org.tizen.common.rest.ui.views.RestViewerLabelProvider;

public class WadlTreeSection {
    private TreeViewer wadlTreeViewer;
    private Composite parent;

    public WadlTreeSection(Composite parent) {
        this.parent = parent;
        this.createTreeViewer();
    }

    private void createTreeViewer() {
        this.wadlTreeViewer = new TreeViewer(this.parent, 2816);
        this.wadlTreeViewer.setContentProvider((IContentProvider)new RestViewerContentProvider(){

            @Override
            public Object[] getChildren(Object parent) {
                if (parent instanceof Application) {
                    List<Resources> list = ((Application)parent).getResources();
                    return list.toArray();
                }
                return new Object[0];
            }

            @Override
            public boolean hasChildren(Object parent) {
                if (parent instanceof Application) {
                    List<Resources> list = ((Application)parent).getResources();
                    return list.size() > 0;
                }
                return false;
            }
        });
        this.wadlTreeViewer.setLabelProvider((IBaseLabelProvider)new RestViewerLabelProvider());
        this.wadlTreeViewer.setInput(RepositoryManager.getInstance().getApplications());
        this.wadlTreeViewer.expandToLevel(-1);
    }

    public TreeViewer getTreeViewer() {
        return this.wadlTreeViewer;
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.wadlTreeViewer.setSelection(selection, reveal);
    }

    public ISelection getSelection() {
        return this.wadlTreeViewer.getSelection();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.wadlTreeViewer.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.wadlTreeViewer.removeSelectionChangedListener(listener);
    }
}

