/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.switchButton;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;

public class SwitchButton
extends Canvas {
    private boolean selection = false;
    private String textForSelect = "On";
    private String textForUnselect = "Off";
    private String text;
    private boolean round = true;
    private Color borderColor = null;
    private Color focusColor = this.getDisplay().getSystemColor(7);
    private Color selectedForegroundColor = this.getDisplay().getSystemColor(1);
    private Color selectedBackgroundColor = new Color((Device)this.getDisplay(), 0, 112, 195);
    private Color unselectedForegroundColor = this.getDisplay().getSystemColor(2);
    private Color unselectedBackgroundColor = new Color((Device)this.getDisplay(), 203, 203, 203);
    private Color buttonBorderColor = new Color((Device)this.getDisplay(), 96, 96, 96);
    private Color buttonBackgroundColor1 = new Color((Device)this.getDisplay(), 254, 254, 254);
    private Color buttonBackgroundColor2 = new Color((Device)this.getDisplay(), 192, 192, 192);
    private int gap = 5;
    private static final int INSIDE_BUTTON_MARGIN = 5;
    private GC gc;
    private final List<SelectionListener> listOfSelectionListeners = new ArrayList<SelectionListener>();
    private boolean mouseInside;

    public SwitchButton(Composite parent, int style) {
        super(parent, style | 0x20000000);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SwitchButton.this.selectedBackgroundColor.dispose();
                SwitchButton.this.unselectedBackgroundColor.dispose();
                SwitchButton.this.buttonBorderColor.dispose();
                SwitchButton.this.buttonBackgroundColor1.dispose();
                SwitchButton.this.buttonBackgroundColor2.dispose();
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                SwitchButton.this.onPaint(event);
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (SwitchButton.this.fireSelectionListeners(e)) {
                    SwitchButton.this.selection = !SwitchButton.this.selection;
                    SwitchButton.this.redraw();
                }
            }
        });
        this.mouseInside = false;
        this.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
                SwitchButton.this.mouseInside = true;
                SwitchButton.this.redraw();
            }

            public void mouseExit(MouseEvent e) {
                SwitchButton.this.mouseInside = false;
                SwitchButton.this.redraw();
            }

            public void mouseEnter(MouseEvent e) {
                SwitchButton.this.mouseInside = true;
                SwitchButton.this.redraw();
            }
        });
    }

    private void onPaint(PaintEvent event) {
        Rectangle rect = this.getClientArea();
        if (rect.width == 0 || rect.height == 0) {
            return;
        }
        this.gc = event.gc;
        this.gc.setAntialias(1);
        Point buttonSize = this.computeButtonSize();
        this.drawSwitchButton(buttonSize);
        this.drawText(buttonSize);
        if (this.borderColor != null) {
            this.drawBorder();
        }
    }

    private void drawSwitchButton(Point buttonSize) {
        this.gc.setForeground(this.buttonBorderColor);
        if (this.round) {
            this.gc.drawRoundRectangle(2, 2, buttonSize.x, buttonSize.y, 3, 3);
        } else {
            this.gc.drawRectangle(2, 2, buttonSize.x, buttonSize.y);
        }
        this.drawRightPart(buttonSize);
        this.drawLeftPart(buttonSize);
        this.gc.setClipping(this.getClientArea());
        this.drawToggleButton(buttonSize);
    }

    private void drawRightPart(Point buttonSize) {
        this.gc.setForeground(this.selectedBackgroundColor);
        this.gc.setBackground(this.selectedBackgroundColor);
        this.gc.setClipping(3, 3, buttonSize.x / 2, buttonSize.y - 1);
        if (this.round) {
            this.gc.fillRoundRectangle(2, 2, buttonSize.x, buttonSize.y, 3, 3);
        } else {
            this.gc.fillRectangle(2, 2, buttonSize.x, buttonSize.y);
        }
        this.gc.setForeground(this.selectedForegroundColor);
        Point textSize = this.gc.textExtent(this.textForSelect);
        this.gc.drawString(this.textForSelect, (buttonSize.x / 2 - textSize.x) / 2 + 3, (buttonSize.y - textSize.y) / 2 + 3);
    }

    private void drawLeftPart(Point buttonSize) {
        this.gc.setForeground(this.unselectedBackgroundColor);
        this.gc.setBackground(this.unselectedBackgroundColor);
        this.gc.setClipping(buttonSize.x / 2 + 3, 3, buttonSize.x / 2, buttonSize.y - 1);
        if (this.round) {
            this.gc.fillRoundRectangle(2, 2, buttonSize.x, buttonSize.y, 3, 3);
        } else {
            this.gc.fillRectangle(2, 2, buttonSize.x, buttonSize.y);
        }
        this.gc.setForeground(this.unselectedForegroundColor);
        Point textSize = this.gc.textExtent(this.textForUnselect);
        this.gc.drawString(this.textForUnselect, buttonSize.x / 2 + (buttonSize.x / 2 - textSize.x) / 2 + 3, (buttonSize.y - textSize.y) / 2 + 3);
    }

    private void drawToggleButton(Point buttonSize) {
        this.gc.setForeground(this.buttonBackgroundColor1);
        this.gc.setBackground(this.buttonBackgroundColor2);
        if (this.selection) {
            this.gc.fillGradientRectangle(3, 3, buttonSize.x / 2, buttonSize.y, true);
        } else {
            this.gc.fillGradientRectangle(buttonSize.x / 2, 3, buttonSize.x / 2 + 2, buttonSize.y - 1, true);
        }
        this.gc.setForeground(this.buttonBorderColor);
        if (this.selection) {
            this.gc.drawRoundRectangle(2, 2, buttonSize.x / 2, buttonSize.y, 3, 3);
        } else {
            this.gc.drawRoundRectangle(buttonSize.x / 2, 2, buttonSize.x / 2 + 2, buttonSize.y, 3, 3);
        }
        if (this.focusColor != null && this.mouseInside) {
            this.gc.setForeground(this.focusColor);
            this.gc.setLineWidth(2);
            if (this.selection) {
                this.gc.drawRoundRectangle(3, 3, buttonSize.x / 2, buttonSize.y - 1, 3, 3);
            } else {
                this.gc.drawRoundRectangle(buttonSize.x / 2 + 1, 3, buttonSize.x / 2, buttonSize.y - 2, 3, 3);
            }
            this.gc.setLineWidth(1);
        }
    }

    private Point computeButtonSize() {
        Point sizeForLeftPart = this.gc.stringExtent(this.textForSelect);
        Point sizeForRightPart = this.gc.stringExtent(this.textForUnselect);
        int width = Math.max(sizeForLeftPart.x, sizeForRightPart.x) * 2 + 10;
        int height = Math.max(sizeForLeftPart.y, sizeForRightPart.y) + 10;
        return new Point(width, height);
    }

    private void drawText(Point buttonSize) {
        this.gc.setForeground(this.getForeground());
        this.gc.setBackground(this.getBackground());
        int widgetHeight = this.computeSize((int)0, (int)0, (boolean)true).y;
        int textHeight = this.gc.stringExtent((String)this.text).y;
        int x = 2 + buttonSize.x + this.gap;
        this.gc.drawString(this.text, x, (widgetHeight - textHeight) / 2);
    }

    private void drawBorder() {
        if (this.borderColor == null) {
            return;
        }
        this.gc.setForeground(this.borderColor);
        Point temp = this.computeSize(0, 0, false);
        if (this.round) {
            this.gc.drawRoundRectangle(0, 0, temp.x - 2, temp.y - 2, 3, 3);
        } else {
            this.gc.drawRectangle(0, 0, temp.x - 2, temp.y - 2);
        }
    }

    private boolean fireSelectionListeners(MouseEvent mouseEvent) {
        for (SelectionListener listener : this.listOfSelectionListeners) {
            Event event = new Event();
            event.button = mouseEvent.button;
            event.display = this.getDisplay();
            event.item = null;
            event.widget = this;
            event.data = null;
            event.time = mouseEvent.time;
            event.x = mouseEvent.x;
            event.y = mouseEvent.y;
            SelectionEvent selEvent = new SelectionEvent(event);
            listener.widgetSelected(selEvent);
            if (selEvent.doit) continue;
            return false;
        }
        return true;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.listOfSelectionListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.listOfSelectionListeners.remove(listener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        boolean disposeGC = false;
        if (this.gc == null) {
            this.gc = new GC((Drawable)this);
            disposeGC = true;
        }
        Point buttonSize = this.computeButtonSize();
        int width = buttonSize.x;
        int height = buttonSize.y;
        if (this.text != null && this.text.trim().length() > 0) {
            Point textSize = this.gc.textExtent(this.text);
            width += textSize.x + this.gap + 1;
        }
        width += 4;
        height += 6;
        if (disposeGC) {
            this.gc.dispose();
        }
        return new Point(width, height);
    }

    public boolean getSelection() {
        this.checkWidget();
        return this.selection;
    }

    public void setSelection(boolean selection) {
        this.checkWidget();
        this.selection = selection;
    }

    public String getTextForSelect() {
        this.checkWidget();
        return this.textForSelect;
    }

    public void setTextForSelect(String textForSelect) {
        this.checkWidget();
        this.textForSelect = textForSelect;
    }

    public String getTextForUnselect() {
        this.checkWidget();
        return this.textForUnselect;
    }

    public void setTextForUnselect(String textForUnselect) {
        this.checkWidget();
        this.textForUnselect = textForUnselect;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public void setText(String text) {
        this.checkWidget();
        this.text = text;
    }

    public boolean isRound() {
        this.checkWidget();
        return this.round;
    }

    public void setRound(boolean round) {
        this.checkWidget();
        this.round = round;
    }

    public Color getBorderColor() {
        this.checkWidget();
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.checkWidget();
        this.borderColor = borderColor;
    }

    public Color getFocusColor() {
        this.checkWidget();
        return this.focusColor;
    }

    public void setFocusColor(Color focusColor) {
        this.checkWidget();
        this.focusColor = focusColor;
    }

    public Color getSelectedForegroundColor() {
        this.checkWidget();
        return this.selectedForegroundColor;
    }

    public void setSelectedForegroundColor(Color selectedForegroundColor) {
        this.checkWidget();
        this.selectedForegroundColor = selectedForegroundColor;
    }

    public Color getSelectedBackgroundColor() {
        this.checkWidget();
        return this.selectedBackgroundColor;
    }

    public void setSelectedBackgroundColor(Color selectedBackgroundColor) {
        this.checkWidget();
        this.selectedBackgroundColor = selectedBackgroundColor;
    }

    public Color getUnselectedForegroundColor() {
        this.checkWidget();
        return this.unselectedForegroundColor;
    }

    public void setUnselectedForegroundColor(Color unselectedForegroundColor) {
        this.checkWidget();
        this.unselectedForegroundColor = unselectedForegroundColor;
    }

    public Color getUnselectedBackgroundColor() {
        this.checkWidget();
        return this.unselectedBackgroundColor;
    }

    public void setUnselectedBackgroundColor(Color unselectedBackgroundColor) {
        this.checkWidget();
        this.unselectedBackgroundColor = unselectedBackgroundColor;
    }

    public Color getButtonBorderColor() {
        this.checkWidget();
        return this.buttonBorderColor;
    }

    public void setButtonBorderColor(Color buttonBorderColor) {
        this.checkWidget();
        this.buttonBorderColor = buttonBorderColor;
    }

    public Color getButtonBackgroundColor1() {
        this.checkWidget();
        return this.buttonBackgroundColor1;
    }

    public void setButtonBackgroundColor1(Color buttonBackgroundColor1) {
        this.checkWidget();
        this.buttonBackgroundColor1 = buttonBackgroundColor1;
    }

    public Color getButtonBackgroundColor2() {
        this.checkWidget();
        return this.buttonBackgroundColor2;
    }

    public void setButtonBackgroundColor2(Color buttonBackgroundColor2) {
        this.checkWidget();
        this.buttonBackgroundColor2 = buttonBackgroundColor2;
    }

    public int getGap() {
        this.checkWidget();
        return this.gap;
    }

    public void setGap(int gap) {
        this.checkWidget();
        this.gap = gap;
    }
}

