/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.ui.dialog;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.sign.ui.CertificateManagerHandler;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.StringUtil;

public class CertificateCheckDialog
extends IconAndMessageDialog {
    protected static final Logger logger = LoggerFactory.getLogger(CertificateCheckDialog.class);
    public static final String BUTTON_CHECK_ID = "org.tizen.common.certificate";
    public static final String OPEN_DIALOG_ID = "org.tizen.common.certificate.open";
    public static final QualifiedName BUTTON_OPEN_DIALOG = new QualifiedName("org.tizen.common.certificate.open", "org.tizen.common.certificate");
    public static final String OPTION_ENABLE = "true";
    public static final String OPTION_DISABLE = "false";
    private String title;
    private IProject project;
    Button btnCheck;

    public CertificateCheckDialog(String message, IProject project) {
        this(SWTUtil.getActiveShell(), "Tizen Studio", message);
        this.project = project;
    }

    public CertificateCheckDialog(Shell parentShell, String dialogTitle, String message) {
        super(parentShell);
        this.title = StringUtil.nvl((String[])new String[]{dialogTitle, JFaceResources.getString((String)"Problem_Occurred")});
        this.message = message;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected Image getImage() {
        return this.getInfoImage();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.createMessageArea(composite);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData childData = new GridData(1808);
        childData.horizontalSpan = 2;
        childData.grabExcessVerticalSpace = false;
        composite.setLayoutData((Object)childData);
        composite.setFont(parent.getFont());
        this.btnCheck = new Button(composite, 32);
        this.btnCheck.setText("Use this as the default and do not ask again");
        try {
            this.initCheck(false);
        }
        catch (CoreException e) {
            logger.error("Fail to get check button information", (Throwable)e);
        }
        return composite;
    }

    protected Control createMessageArea(Composite composite) {
        Image image = this.getImage();
        if (image != null) {
            this.imageLabel = new Label(composite, 0);
            image.setBackground(this.imageLabel.getBackground());
            this.imageLabel.setImage(image);
            this.addAccessibleListeners(this.imageLabel, image);
            GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)this.imageLabel);
        }
        if (this.message != null) {
            Link messageLabel = new Link(composite, this.getMessageLabelStyle());
            messageLabel.setText(this.message);
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)messageLabel);
            messageLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    CertificateManagerHandler certHandler = new CertificateManagerHandler();
                    try {
                        certHandler.execute(null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        return composite;
    }

    private void addAccessibleListeners(Label label, final Image image) {
        label.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent event) {
                String accessibleMessage = CertificateCheckDialog.this.getAccessibleMessageFor(image);
                if (accessibleMessage == null) {
                    return;
                }
                event.result = accessibleMessage;
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button buildPackageButton = this.createButton(parent, 10, IDialogConstants.PROCEED_LABEL, true);
        buildPackageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (CertificateCheckDialog.this.btnCheck.getSelection()) {
                        CertificateCheckDialog.this.project.setPersistentProperty(BUTTON_OPEN_DIALOG, CertificateCheckDialog.OPTION_ENABLE);
                    } else {
                        CertificateCheckDialog.this.project.setPersistentProperty(BUTTON_OPEN_DIALOG, CertificateCheckDialog.OPTION_DISABLE);
                    }
                }
                catch (CoreException e1) {
                    logger.error("Fail to get check button information", (Throwable)e1);
                }
                CertificateCheckDialog.this.setReturnCode(0);
                CertificateCheckDialog.this.close();
            }
        });
        Button cancelButton = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CertificateCheckDialog.this.setReturnCode(1);
                CertificateCheckDialog.this.close();
            }
        });
    }

    private String getAccessibleMessageFor(Image image) {
        if (image.equals((Object)this.getErrorImage())) {
            return JFaceResources.getString((String)"error");
        }
        if (image.equals((Object)this.getWarningImage())) {
            return JFaceResources.getString((String)"warning");
        }
        if (image.equals((Object)this.getInfoImage())) {
            return JFaceResources.getString((String)"info");
        }
        if (image.equals((Object)this.getQuestionImage())) {
            return JFaceResources.getString((String)"question");
        }
        return null;
    }

    private void initCheck(boolean isDefault) throws CoreException {
        if (this.project.getPersistentProperty(BUTTON_OPEN_DIALOG) == null) {
            this.btnCheck.setSelection(false);
        } else if (this.project.getPersistentProperty(BUTTON_OPEN_DIALOG).equals(OPTION_ENABLE)) {
            this.btnCheck.setSelection(true);
        } else if (this.project.getPersistentProperty(BUTTON_OPEN_DIALOG).equals(OPTION_DISABLE)) {
            this.btnCheck.setSelection(false);
        }
    }
}

