/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.IOException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.Transport;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(common=true, usage="usage_LsRemote")
class LsRemote
extends TextBuiltin {
    @Option(name="--timeout", metaVar="metaVar_service", usage="usage_abortConnectionIfNoActivity")
    int timeout = -1;
    @Argument(index=0, metaVar="metaVar_uriish", required=true)
    private String remote;

    LsRemote() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run() throws Exception {
        Transport tn = Transport.open(this.db, this.remote);
        if (0 <= this.timeout) {
            tn.setTimeout(this.timeout);
        }
        FetchConnection c = tn.openFetch();
        try {
            for (Ref r : c.getRefs()) {
                this.show(r.getObjectId(), r.getName());
                if (r.getPeeledObjectId() == null) continue;
                this.show(r.getPeeledObjectId(), r.getName() + "^{}");
            }
        }
        finally {
            c.close();
            tn.close();
        }
    }

    private void show(AnyObjectId id, String name) throws IOException {
        this.outw.print(id.name());
        this.outw.print('\t');
        this.outw.print(name);
        this.outw.println();
    }
}

