/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.gom.smartlaunch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.resources.ProjectExplorer;
import org.tizen.common.gom.launch.GomLaunchData;
import org.tizen.common.util.ViewUtil;

public class GomSmartLaunchManager
implements ISelectionListener,
ILaunchesListener,
ILaunchConfigurationListener,
IResourceChangeListener {
    private static GomSmartLaunchManager launchManager = null;
    private HashMap<IProject, GomLaunchData> map = new HashMap();
    private List<GomLaunchData> launchList = new ArrayList<GomLaunchData>();
    private int max = 10;

    public static GomSmartLaunchManager getDefault() {
        if (launchManager == null) {
            launchManager = new GomSmartLaunchManager();
        }
        return launchManager;
    }

    public void addListener() {
        IWorkbenchWindow workbenchWindow = ViewUtil.getWorkbenchWindow();
        if (workbenchWindow != null && workbenchWindow.getSelectionService() != null) {
            workbenchWindow.getSelectionService().addPostSelectionListener((ISelectionListener)this);
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 4);
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.addLaunchConfigurationListener((ILaunchConfigurationListener)this);
        launchManager.addLaunchListener((ILaunchesListener)this);
    }

    public void removeListener() {
        IWorkbenchWindow workbenchWindow = ViewUtil.getWorkbenchWindow();
        if (workbenchWindow != null && workbenchWindow.getSelectionService() != null) {
            workbenchWindow.getSelectionService().removePostSelectionListener((ISelectionListener)this);
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.removeLaunchConfigurationListener((ILaunchConfigurationListener)this);
        launchManager.removeLaunchListener((ILaunchesListener)this);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IProject project;
        GomLaunchData data;
        Object s;
        if (selection instanceof IStructuredSelection && part instanceof ProjectExplorer && (s = ((IStructuredSelection)selection).getFirstElement()) instanceof IProject && (data = this.map.get(project = (IProject)s)) != null) {
            IViewSite site = (IViewSite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite();
            ILabelProvider labelProvider = (ILabelProvider)((ProjectExplorer)part).getCommonViewer().getLabelProvider();
            Image image = labelProvider.getImage(((IStructuredSelection)selection).getFirstElement());
            site.getActionBars().getStatusLineManager().setMessage(image, data.getDataInfo());
        }
    }

    public List<GomLaunchData> getLaunchList() {
        return this.launchList;
    }

    public void launchesRemoved(ILaunch[] launches) {
    }

    public void launchesAdded(ILaunch[] launches) {
        this.updateProjectLaunchData(launches[0]);
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IProject project = (IProject)event.getResource();
        this.removeLaunchHistory(project);
    }

    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
    }

    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
    }

    private void updateProjectLaunchData(ILaunch launch) {
        GomLaunchData launchData = new GomLaunchData(launch);
        this.map.put(launchData.getProject(), launchData);
        this.updateLaunchHistory(launchData);
    }

    public void updateLaunchHistory(GomLaunchData launchInfo) {
        Iterator<GomLaunchData> iter = this.launchList.iterator();
        while (iter.hasNext()) {
            GomLaunchData info = iter.next();
            if (!launchInfo.getDataInfo().equals(info.getDataInfo())) continue;
            iter.remove();
        }
        this.launchList.add(launchInfo);
        iter = this.launchList.iterator();
        while (iter.hasNext()) {
            iter.next();
            if (this.launchList.size() <= this.max) break;
            iter.remove();
        }
    }

    private void removeLaunchHistory(Object obj) {
        Iterator<GomLaunchData> iter = this.launchList.iterator();
        while (iter.hasNext()) {
            ILaunchConfiguration configuration;
            GomLaunchData item = iter.next();
            if (obj instanceof IProject) {
                IProject project = (IProject)obj;
                if (!project.getName().equals(item.getProject().getName())) continue;
                iter.remove();
                continue;
            }
            if (!(obj instanceof ILaunchConfiguration) || !(configuration = (ILaunchConfiguration)obj).getName().equals(item.getLaunchConfiguration().getName())) continue;
            iter.remove();
        }
    }
}

