/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.ui.dialog;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.common.sign.ui.dialog.Messages;
import org.tizen.common.sign.ui.model.CertificateInformation;
import org.tizen.common.util.StringUtil;

public class CertificateInformationDialog
extends Dialog {
    private CertificateInformation certInfo;
    private Shell shell;
    private static final String INFO_FORMAT = "%s : %s\n";

    public CertificateInformationDialog(Shell parent) {
        super(parent);
    }

    public CertificateInformationDialog(Shell parent, CertificateInformation certInfo) {
        super(parent);
        this.certInfo = certInfo;
    }

    protected Control createDialogArea(Composite parent) {
        Composite baseComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(baseComposite, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData layoutData = new GridData(768);
        layoutData.widthHint = 400;
        composite.setLayoutData((Object)layoutData);
        StyledText txInformation = new StyledText(composite, 66);
        layoutData = new GridData(1808);
        txInformation.setLayoutData((Object)layoutData);
        txInformation.setBackground(this.shell.getBackground());
        txInformation.setEditable(false);
        txInformation.setCaret(null);
        this.appendText(txInformation, Messages.CERT_INFO_DLG_IDENTITY, this.certInfo.getSubjectCommonName());
        this.appendText(txInformation, Messages.CERT_INFO_DLG_COUNTRY, this.certInfo.getSubjectCountry());
        this.appendText(txInformation, Messages.CERT_INFO_DLG_STATE, this.certInfo.getSubjectState());
        this.appendText(txInformation, Messages.CERT_INFO_DLG_CITY, this.certInfo.getSubjectLocality());
        this.appendText(txInformation, Messages.CERT_INFO_DLG_ORG, this.certInfo.getSubjectOrganization());
        this.appendText(txInformation, Messages.CERT_INFO_DLG_DEPARTMENT, this.certInfo.getSubjectOrganizationalUnit());
        this.appendText(txInformation, Messages.CERT_INFO_DLG_EXPDATE, this.certInfo.getExpires());
        this.appendText(txInformation, Messages.CERT_INFO_DLG_ISSUER, this.certInfo.getIssuerCommonName());
        this.appendText(txInformation, Messages.CERT_INFO_DLG_FILEPATH, this.certInfo.getFilepath());
        return baseComposite;
    }

    private void appendText(StyledText widget, String key, String value) {
        if (!StringUtil.isEmpty((CharSequence)value)) {
            int styleStart = widget.getText().length();
            widget.append(String.format(INFO_FORMAT, key, value));
            this.setStyleRanges(widget, styleStart, key.length());
        }
    }

    private void setStyleRanges(StyledText widget, int start, int length) {
        StyleRange style = new StyleRange();
        style.start = start;
        style.length = length;
        style.fontStyle = 1;
        widget.setStyleRange(style);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.CERT_INFO_DLG_TITLE);
        this.shell = newShell;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10 | 0x400);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button closeButton = this.createButton(parent, 12, Messages.CERT_INFO_DLG_CLOSE, true);
        closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CertificateInformationDialog.this.setReturnCode(1);
                CertificateInformationDialog.this.close();
            }
        });
    }
}

